/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.idmanagement;

import com.google.common.base.Preconditions;
import java.time.Duration;
import org.janusgraph.diskstorage.IDAuthority;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.idassigner.IDBlockSizer;
import org.janusgraph.util.encoding.StringEncoding;

public abstract class AbstractIDAuthority
implements IDAuthority {
    protected static final long BASE_ID = 1L;
    protected final Duration idApplicationWaitMS;
    protected final String uid;
    protected final byte[] uidBytes;
    protected final String metricsPrefix;
    private IDBlockSizer blockSizer;
    private volatile boolean isActive;

    public AbstractIDAuthority(Configuration config) {
        this.uid = config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0]);
        this.uidBytes = this.uid.getBytes(StringEncoding.UTF8_CHARSET);
        this.isActive = false;
        this.idApplicationWaitMS = config.get(GraphDatabaseConfiguration.IDAUTHORITY_WAIT, new String[0]);
        this.metricsPrefix = "org.janusgraph.sys";
    }

    @Override
    public synchronized void setIDBlockSizer(IDBlockSizer sizer) {
        Preconditions.checkNotNull(sizer);
        if (this.isActive) {
            throw new IllegalStateException("IDBlockSizer cannot be changed after IDAuthority is in use");
        }
        this.blockSizer = sizer;
    }

    @Override
    public String getUniqueID() {
        return this.uid;
    }

    protected StaticBuffer getPartitionKey(int partition) {
        return BufferUtil.getIntBuffer(partition);
    }

    protected long getBlockSize(int idNamespace) {
        Preconditions.checkArgument(this.blockSizer != null, "Blocksizer has not yet been initialized");
        this.isActive = true;
        long blockSize = this.blockSizer.getBlockSize(idNamespace);
        Preconditions.checkArgument(blockSize > 0L, "Invalid block size: %s", new Object[]{blockSize});
        Preconditions.checkArgument(blockSize < this.getIdUpperBound(idNamespace), "Block size [%s] cannot be larger than upper bound [%s] for partition [%s]", new Object[]{blockSize, this.getIdUpperBound(idNamespace), idNamespace});
        return blockSize;
    }

    protected long getIdUpperBound(int idNamespace) {
        Preconditions.checkArgument(this.blockSizer != null, "Blocksizer has not yet been initialized");
        this.isActive = true;
        long upperBound = this.blockSizer.getIdUpperBound(idNamespace);
        Preconditions.checkArgument(upperBound > 0L, "Invalid upper bound: %s", new Object[]{upperBound});
        return upperBound;
    }
}

