/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.idmanagement;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.IDBlock;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.idmanagement.AbstractIDAuthority;
import org.janusgraph.diskstorage.idmanagement.ConflictAvoidanceMode;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.locking.TemporaryLockingException;
import org.janusgraph.diskstorage.util.BackendOperation;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.WriteBufferUtil;
import org.janusgraph.diskstorage.util.WriteByteBuffer;
import org.janusgraph.diskstorage.util.time.Durations;
import org.janusgraph.diskstorage.util.time.Timer;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.idassigner.IDPoolExhaustedException;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.util.stats.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentKeyIDAuthority
extends AbstractIDAuthority
implements BackendOperation.TransactionalProvider {
    private static final Logger log = LoggerFactory.getLogger(ConsistentKeyIDAuthority.class);
    private static final StaticBuffer LOWER_SLICE = BufferUtil.zeroBuffer(1);
    private static final StaticBuffer UPPER_SLICE = BufferUtil.oneBuffer(17);
    private static final int ROLLBACK_ATTEMPTS = 5;
    private final StoreManager manager;
    private final KeyColumnValueStore idStore;
    private final StandardBaseTransactionConfig.Builder storeTxConfigBuilder;
    private final TimestampProvider times;
    private final Duration rollbackWaitTime = Duration.ofMillis(200L);
    private final int partitionBitWidth;
    private final int uniqueIdBitWidth;
    private final int uniqueIDUpperBound;
    private final int uniqueId;
    private final boolean randomizeUniqueId;
    protected final int randomUniqueIDLimit;
    private final Duration waitGracePeriod;
    private final boolean supportsInterruption;
    private final Random random = new Random();

    public ConsistentKeyIDAuthority(KeyColumnValueStore idStore, StoreManager manager, Configuration config) throws BackendException {
        super(config);
        Preconditions.checkArgument(manager.getFeatures().isKeyConsistent());
        this.manager = manager;
        this.idStore = idStore;
        this.times = config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]);
        this.waitGracePeriod = this.idApplicationWaitMS.dividedBy(10L);
        Preconditions.checkNotNull(this.times);
        this.supportsInterruption = manager.getFeatures().supportsInterruption();
        this.partitionBitWidth = NumberUtil.getPowerOf2(config.get(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, new String[0]).intValue());
        Preconditions.checkArgument(this.partitionBitWidth >= 0 && this.partitionBitWidth <= 16);
        this.uniqueIdBitWidth = config.get(GraphDatabaseConfiguration.IDAUTHORITY_CAV_BITS, new String[0]);
        Preconditions.checkArgument(this.uniqueIdBitWidth <= 16 && this.uniqueIdBitWidth >= 0);
        this.uniqueIDUpperBound = 1 << this.uniqueIdBitWidth;
        this.storeTxConfigBuilder = new StandardBaseTransactionConfig.Builder().groupName(this.metricsPrefix).timestampProvider(this.times);
        ConflictAvoidanceMode conflictAvoidanceMode = config.get(GraphDatabaseConfiguration.IDAUTHORITY_CONFLICT_AVOIDANCE, new String[0]);
        if (conflictAvoidanceMode.equals((Object)ConflictAvoidanceMode.GLOBAL_AUTO)) {
            Preconditions.checkArgument(!config.has(GraphDatabaseConfiguration.IDAUTHORITY_CAV_TAG, new String[0]), "Conflicting configuration: a unique id and randomization have been set");
            this.randomizeUniqueId = true;
            this.randomUniqueIDLimit = config.get(GraphDatabaseConfiguration.IDAUTHORITY_CAV_RETRIES, new String[0]);
            Preconditions.checkArgument(this.randomUniqueIDLimit < this.uniqueIDUpperBound, "Cannot have more uid retries [%d] than available values [%d]", new Object[]{this.randomUniqueIDLimit, this.uniqueIDUpperBound});
            this.uniqueId = -1;
            this.storeTxConfigBuilder.customOptions(manager.getFeatures().getKeyConsistentTxConfig());
        } else {
            this.randomizeUniqueId = false;
            Preconditions.checkArgument(!config.has(GraphDatabaseConfiguration.IDAUTHORITY_CAV_RETRIES, new String[0]), "Retry count is only meaningful when " + GraphDatabaseConfiguration.IDAUTHORITY_CONFLICT_AVOIDANCE + " is set to " + (Object)((Object)ConflictAvoidanceMode.GLOBAL_AUTO));
            this.randomUniqueIDLimit = 0;
            if (conflictAvoidanceMode.equals((Object)ConflictAvoidanceMode.LOCAL_MANUAL)) {
                Preconditions.checkArgument(config.has(GraphDatabaseConfiguration.IDAUTHORITY_CAV_TAG, new String[0]), "Need to configure a unique id in order to use local consistency");
                this.storeTxConfigBuilder.customOptions(manager.getFeatures().getLocalKeyConsistentTxConfig());
            } else {
                this.storeTxConfigBuilder.customOptions(manager.getFeatures().getKeyConsistentTxConfig());
            }
            this.uniqueId = config.get(GraphDatabaseConfiguration.IDAUTHORITY_CAV_TAG, new String[0]);
            Preconditions.checkArgument(this.uniqueId >= 0, "Invalid unique id: %s", new Object[]{this.uniqueId});
            Preconditions.checkArgument(this.uniqueId < this.uniqueIDUpperBound, "Unique id is too large for bit width [%s]: %s", new Object[]{this.uniqueIdBitWidth, this.uniqueId});
        }
        Preconditions.checkArgument(this.randomUniqueIDLimit >= 0);
    }

    @Override
    public List<KeyRange> getLocalIDPartition() throws BackendException {
        return this.manager.getLocalKeyPartition();
    }

    @Override
    public void close() throws BackendException {
        this.idStore.close();
    }

    @Override
    public boolean supportsInterruption() {
        return this.supportsInterruption;
    }

    @Override
    public StoreTransaction openTx() throws BackendException {
        return this.manager.beginTransaction(this.storeTxConfigBuilder.build());
    }

    private long getCurrentID(StaticBuffer partitionKey) throws BackendException {
        List blocks = BackendOperation.execute(txh -> this.idStore.getSlice(new KeySliceQuery(partitionKey, LOWER_SLICE, UPPER_SLICE).setLimit(5), txh), this, this.times);
        if (blocks == null) {
            throw new TemporaryBackendException("Could not read from storage");
        }
        long latest = 1L;
        for (Entry e : blocks) {
            long counterVal = this.getBlockValue(e);
            if (latest >= counterVal) continue;
            latest = counterVal;
        }
        return latest;
    }

    private int getUniquePartitionID() {
        int id = this.randomizeUniqueId ? this.random.nextInt(this.uniqueIDUpperBound) : this.uniqueId;
        assert (id >= 0 && id < this.uniqueIDUpperBound);
        return id;
    }

    private StaticBuffer getPartitionKey(int partition, int idNamespace, int uniqueId) {
        assert (partition >= 0 && partition < 1 << this.partitionBitWidth);
        assert (idNamespace >= 0);
        assert (uniqueId >= 0 && uniqueId < 1 << this.uniqueIdBitWidth);
        int[] components = new int[]{(this.partitionBitWidth > 0 ? partition << 32 - this.partitionBitWidth : 0) + uniqueId, idNamespace};
        return BufferUtil.getIntBuffer(components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized IDBlock getIDBlock(int partition, int idNamespace, Duration timeout) throws BackendException {
        Preconditions.checkArgument(partition >= 0 && partition < 1 << this.partitionBitWidth, "Invalid partition id [%s] for bit width [%s]", new Object[]{partition, this.partitionBitWidth});
        Preconditions.checkArgument(idNamespace >= 0);
        Timer methodTime = this.times.getTimer().start();
        long blockSize = this.getBlockSize(idNamespace);
        long idUpperBound = this.getIdUpperBound(idNamespace);
        int maxAvailableBits = VariableLong.unsignedBitLength(idUpperBound) - 1 - this.uniqueIdBitWidth;
        Preconditions.checkArgument(maxAvailableBits > 0, "Unique id bit width [%s] is too wide for id-namespace [%s] id bound [%s]", new Object[]{this.uniqueIdBitWidth, idNamespace, idUpperBound});
        long idBlockUpperBound = 1L << maxAvailableBits;
        ArrayList<Integer> exhaustedUniquePIDs = new ArrayList<Integer>(this.randomUniqueIDLimit);
        Duration backoffMS = this.idApplicationWaitMS;
        Preconditions.checkArgument(idBlockUpperBound > blockSize, "Block size [%s] is larger than upper bound [%s] for bit width [%s]", new Object[]{blockSize, idBlockUpperBound, this.uniqueIdBitWidth});
        block12: while (true) {
            int attempt;
            StaticBuffer finalTarget;
            StaticBuffer target;
            StaticBuffer partitionKey;
            block30: {
                int attempt2;
                ConsistentKeyIDBlock consistentKeyIDBlock;
                block29: {
                    if (methodTime.elapsed().compareTo(timeout) >= 0) {
                        throw new TemporaryLockingException(String.format("Reached timeout %d (%s elapsed) when attempting to allocate id block on partition(%d)-namespace(%d)", timeout.getNano(), methodTime.toString(), partition, idNamespace));
                    }
                    int uniquePID = this.getUniquePartitionID();
                    partitionKey = this.getPartitionKey(partition, idNamespace, uniquePID);
                    try {
                        long nextStart = this.getCurrentID(partitionKey);
                        if (idBlockUpperBound - blockSize <= nextStart) {
                            log.info("ID overflow detected on partition({})-namespace({}) with uniqueid {}. Current id {}, block size {}, and upper bound {} for bit width {}.", partition, idNamespace, uniquePID, nextStart, blockSize, idBlockUpperBound, this.uniqueIdBitWidth);
                            if (!this.randomizeUniqueId) throw new IDPoolExhaustedException("Exhausted id block for partition(" + partition + ")-namespace(" + idNamespace + ") with upper bound: " + idBlockUpperBound);
                            exhaustedUniquePIDs.add(uniquePID);
                            if (exhaustedUniquePIDs.size() == this.randomUniqueIDLimit) {
                                throw new IDPoolExhaustedException(String.format("Exhausted %d uniqueid(s) on partition(%d)-namespace(%d): %s", exhaustedUniquePIDs.size(), partition, idNamespace, Joiner.on(",").join(exhaustedUniquePIDs)));
                            }
                            throw new UniqueIDExhaustedException(String.format("Exhausted ID partition(%d)-namespace(%d) with uniqueid %d (uniqueid attempt %d/%d)", partition, idNamespace, uniquePID, exhaustedUniquePIDs.size(), this.randomUniqueIDLimit));
                        }
                        assert (idBlockUpperBound - blockSize > nextStart);
                        long nextEnd = nextStart + blockSize;
                        target = null;
                        boolean success = false;
                        try {
                            Timer writeTimer = this.times.getTimer().start();
                            finalTarget = target = this.getBlockApplication(nextEnd, writeTimer.getStartTime());
                            BackendOperation.execute(txh -> {
                                this.idStore.mutate(partitionKey, Collections.singletonList(StaticArrayEntry.of(finalTarget)), KeyColumnValueStore.NO_DELETIONS, txh);
                                return true;
                            }, this, this.times);
                            writeTimer.stop();
                            Duration writeElapsed = writeTimer.elapsed();
                            if (this.idApplicationWaitMS.compareTo(writeElapsed) < 0) {
                                throw new TemporaryBackendException("Wrote claim for id block [" + nextStart + ", " + nextEnd + ") in " + writeElapsed + " => too slow, threshold is: " + this.idApplicationWaitMS);
                            }
                            assert (0 != target.length());
                            StaticBuffer[] slice = this.getBlockSlice(nextEnd);
                            this.sleepAndConvertInterrupts(this.idApplicationWaitMS.plus(this.waitGracePeriod));
                            List blocks = BackendOperation.execute(txh -> this.idStore.getSlice(new KeySliceQuery(partitionKey, slice[0], slice[1]), txh), this, this.times);
                            if (blocks == null) {
                                throw new TemporaryBackendException("Could not read from storage");
                            }
                            if (blocks.isEmpty()) {
                                throw new PermanentBackendException("It seems there is a race-condition in the block application. If you have multiple JanusGraph instances running on one physical machine, ensure that they have unique machine idAuthorities");
                            }
                            if (target.equals(((Entry)blocks.get(0)).getColumnAs(StaticBuffer.STATIC_FACTORY))) {
                                ConsistentKeyIDBlock idBlock = new ConsistentKeyIDBlock(nextStart, blockSize, this.uniqueIdBitWidth, uniquePID);
                                if (log.isDebugEnabled()) {
                                    log.debug("Acquired ID block [{}] on partition({})-namespace({}) (my rid is {})", idBlock, partition, idNamespace, this.uid);
                                }
                                success = true;
                                consistentKeyIDBlock = idBlock;
                                if (success) return consistentKeyIDBlock;
                                if (null == target) return consistentKeyIDBlock;
                                attempt2 = 0;
                                break block29;
                            }
                            log.debug("Failed to acquire ID block [{},{}) (another host claimed it first)", (Object)nextStart, (Object)nextEnd);
                            if (success || null == target) continue;
                            attempt = 0;
                            break block30;
                        }
                        catch (Throwable throwable) {
                            if (success) throw throwable;
                            if (null == target) throw throwable;
                            int attempt3 = 0;
                            while (attempt3 < 5) {
                                try {
                                    StaticBuffer finalTarget3 = target;
                                    BackendOperation.execute(txh -> {
                                        this.idStore.mutate(partitionKey, KeyColumnValueStore.NO_ADDITIONS, Collections.singletonList(finalTarget2), txh);
                                        return true;
                                    }, new BackendOperation.TransactionalProvider(){

                                        @Override
                                        public StoreTransaction openTx() throws BackendException {
                                            return ConsistentKeyIDAuthority.this.manager.beginTransaction(ConsistentKeyIDAuthority.this.storeTxConfigBuilder.build());
                                        }

                                        @Override
                                        public void close() {
                                        }
                                    }, this.times);
                                    throw throwable;
                                }
                                catch (BackendException e) {
                                    log.warn("Storage exception while deleting old block application - retrying in {}", (Object)this.rollbackWaitTime, (Object)e);
                                    if (!this.rollbackWaitTime.isZero()) {
                                        this.sleepAndConvertInterrupts(this.rollbackWaitTime);
                                    }
                                    ++attempt3;
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (UniqueIDExhaustedException e) {
                        log.warn(e.getMessage());
                        continue;
                    }
                    catch (TemporaryBackendException e) {
                        backoffMS = Durations.min(backoffMS.multipliedBy(2L), this.idApplicationWaitMS.multipliedBy(32L));
                        log.warn("Temporary storage exception while acquiring id block - retrying in {}: {}", (Object)backoffMS, (Object)e);
                        this.sleepAndConvertInterrupts(backoffMS);
                        continue;
                    }
                }
                while (attempt2 < 5) {
                    try {
                        StaticBuffer finalTarget2 = target;
                        BackendOperation.execute(txh -> {
                            this.idStore.mutate(partitionKey, KeyColumnValueStore.NO_ADDITIONS, Collections.singletonList(finalTarget2), txh);
                            return true;
                        }, new /* invalid duplicate definition of identical inner class */, this.times);
                        return consistentKeyIDBlock;
                    }
                    catch (BackendException e) {
                        log.warn("Storage exception while deleting old block application - retrying in {}", (Object)this.rollbackWaitTime, (Object)e);
                        if (!this.rollbackWaitTime.isZero()) {
                            this.sleepAndConvertInterrupts(this.rollbackWaitTime);
                        }
                        ++attempt2;
                    }
                }
                return consistentKeyIDBlock;
            }
            while (true) {
                if (attempt >= 5) continue block12;
                try {
                    finalTarget = target;
                    BackendOperation.execute(txh -> {
                        this.idStore.mutate(partitionKey, KeyColumnValueStore.NO_ADDITIONS, Collections.singletonList(finalTarget2), txh);
                        return true;
                    }, new /* invalid duplicate definition of identical inner class */, this.times);
                    continue block12;
                }
                catch (BackendException e) {
                    log.warn("Storage exception while deleting old block application - retrying in {}", (Object)this.rollbackWaitTime, (Object)e);
                    if (!this.rollbackWaitTime.isZero()) {
                        this.sleepAndConvertInterrupts(this.rollbackWaitTime);
                    }
                    ++attempt;
                    continue;
                }
                break;
            }
        }
    }

    private StaticBuffer[] getBlockSlice(long blockValue) {
        StaticBuffer[] slice = new StaticBuffer[]{new WriteByteBuffer(16).putLong(-blockValue).putLong(0L).getStaticBuffer(), new WriteByteBuffer(16).putLong(-blockValue).putLong(-1L).getStaticBuffer()};
        return slice;
    }

    private StaticBuffer getBlockApplication(long blockValue, Instant timestamp) {
        WriteByteBuffer bb = new WriteByteBuffer(16 + this.uidBytes.length);
        bb.putLong(-blockValue).putLong(this.times.getTime(timestamp));
        WriteBufferUtil.put((WriteBuffer)bb, this.uidBytes);
        return bb.getStaticBuffer();
    }

    private long getBlockValue(Entry column) {
        return -column.getLong(0);
    }

    private void sleepAndConvertInterrupts(Duration d) throws BackendException {
        try {
            this.times.sleepPast(this.times.getTime().plus(d));
        }
        catch (InterruptedException e) {
            throw new PermanentBackendException(e);
        }
    }

    private static class ConsistentKeyIDBlock
    implements IDBlock {
        private final long startIDCount;
        private final long numIds;
        private final int uniqueIDBitWidth;
        private final int uniqueID;

        private ConsistentKeyIDBlock(long startIDCount, long numIDs, int uniqueIDBitWidth, int uniqueID) {
            this.startIDCount = startIDCount;
            this.numIds = numIDs;
            this.uniqueIDBitWidth = uniqueIDBitWidth;
            this.uniqueID = uniqueID;
        }

        @Override
        public long numIds() {
            return this.numIds;
        }

        @Override
        public long getId(long index) {
            if (index < 0L || index >= this.numIds) {
                throw new ArrayIndexOutOfBoundsException((int)index);
            }
            assert (this.uniqueID < 1 << this.uniqueIDBitWidth);
            return (this.startIDCount + index << this.uniqueIDBitWidth) + (long)this.uniqueID;
        }

        public String toString() {
            String interval = "[" + this.startIDCount + "," + (this.startIDCount + this.numIds) + ")";
            if (this.uniqueIDBitWidth > 0) {
                interval = interval + "/" + this.uniqueID + ":" + this.uniqueIDBitWidth;
            }
            return interval;
        }
    }

    private static class UniqueIDExhaustedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UniqueIDExhaustedException(String msg) {
            super(msg);
        }
    }
}

