/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.indexing.KeyInformation;

public class StandardKeyInformation
implements KeyInformation {
    private final Class<?> dataType;
    private final Parameter[] parameters;
    private final Cardinality cardinality;

    public StandardKeyInformation(Class<?> dataType, Cardinality cardinality, Parameter ... parameters) {
        Preconditions.checkNotNull(dataType);
        Preconditions.checkNotNull(parameters);
        this.dataType = dataType;
        this.parameters = parameters;
        this.cardinality = cardinality;
    }

    public StandardKeyInformation(PropertyKey key, Parameter ... parameters) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(parameters);
        this.dataType = key.dataType();
        this.parameters = parameters;
        this.cardinality = key.cardinality();
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean hasParameters() {
        return this.parameters.length > 0;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public Cardinality getCardinality() {
        return this.cardinality;
    }
}

