/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.janusgraph.diskstorage.StaticBuffer;

public class KeySelector {
    private final Predicate<StaticBuffer> keyFilter;
    private final int limit;
    private int count;

    public KeySelector(Predicate<StaticBuffer> keyFilter, int limit) {
        Preconditions.checkArgument(limit > 0, "The count limit needs to be positive. Given: " + limit);
        Preconditions.checkArgument(keyFilter != null);
        this.keyFilter = keyFilter;
        this.limit = limit;
        this.count = 0;
    }

    public static KeySelector of(int limit) {
        return new KeySelector(Predicates.alwaysTrue(), limit);
    }

    public boolean include(StaticBuffer key) {
        if (this.keyFilter.apply(key)) {
            ++this.count;
            return true;
        }
        return false;
    }

    public boolean reachedLimit() {
        return this.count >= this.limit;
    }
}

