/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import org.janusgraph.diskstorage.locking.LocalLockMediator;
import org.janusgraph.diskstorage.locking.LocalLockMediatorProvider;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LocalLockMediators implements LocalLockMediatorProvider
{
    INSTANCE;

    private static final Logger log;
    private final ConcurrentHashMap<String, LocalLockMediator<?>> mediators = new ConcurrentHashMap();

    @Override
    public <T> LocalLockMediator<T> get(String namespace, TimestampProvider times) {
        Preconditions.checkNotNull(namespace);
        LocalLockMediator<Object> m = this.mediators.get(namespace);
        if (null == m) {
            m = new LocalLockMediator(namespace, times);
            LocalLockMediator<?> old = this.mediators.putIfAbsent(namespace, m);
            if (null != old) {
                m = old;
            } else {
                log.debug("Local lock mediator instantiated for namespace {}", (Object)namespace);
            }
        }
        return m;
    }

    public void clear() {
        this.mediators.clear();
    }

    public void clear(String namespace) {
        this.mediators.entrySet().removeIf(e -> ((String)e.getKey()).equals(namespace));
    }

    static {
        log = LoggerFactory.getLogger(LocalLockMediators.class);
    }
}

