/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.log.util;

import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.log.Message;
import org.janusgraph.diskstorage.log.MessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMessageJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProcessMessageJob.class);
    private final Message message;
    private final MessageReader reader;

    public ProcessMessageJob(Message message, MessageReader reader) {
        Preconditions.checkArgument(message != null && reader != null);
        this.message = message;
        this.reader = reader;
    }

    @Override
    public void run() {
        try {
            log.debug("Passing {} to {}", (Object)this.message, (Object)this.reader);
            this.reader.read(this.message);
        }
        catch (Throwable e) {
            log.error("Encountered exception when processing message [" + this.message + "] by reader [" + this.reader + "]:", e);
        }
    }
}

