/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.graphdb.relations.RelationCache;

class BaseStaticArrayEntry
extends StaticArrayBuffer
implements Entry {
    private final int valuePosition;

    public BaseStaticArrayEntry(byte[] array, int offset, int limit, int valuePosition) {
        super(array, offset, limit);
        Preconditions.checkArgument(valuePosition > 0);
        Preconditions.checkArgument(valuePosition <= this.length());
        this.valuePosition = valuePosition;
    }

    public BaseStaticArrayEntry(byte[] array, int limit, int valuePosition) {
        this(array, 0, limit, valuePosition);
    }

    public BaseStaticArrayEntry(byte[] array, int valuePosition) {
        this(array, 0, array.length, valuePosition);
    }

    public BaseStaticArrayEntry(StaticBuffer buffer, int valuePosition) {
        super(buffer);
        Preconditions.checkArgument(valuePosition > 0);
        Preconditions.checkArgument(valuePosition <= this.length());
        this.valuePosition = valuePosition;
    }

    @Override
    public int getValuePosition() {
        return this.valuePosition;
    }

    @Override
    public boolean hasValue() {
        return this.valuePosition < this.length();
    }

    @Override
    public StaticBuffer getColumn() {
        return this.getColumnAs(StaticBuffer.STATIC_FACTORY);
    }

    @Override
    public <T> T getColumnAs(StaticBuffer.Factory<T> factory) {
        return super.as(factory, 0, this.valuePosition);
    }

    @Override
    public StaticBuffer getValue() {
        return this.getValueAs(StaticBuffer.STATIC_FACTORY);
    }

    @Override
    public <T> T getValueAs(StaticBuffer.Factory<T> factory) {
        return super.as(factory, this.valuePosition, super.length() - this.valuePosition);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof StaticBuffer)) {
            return false;
        }
        Entry b = (Entry)o;
        return this.getValuePosition() == b.getValuePosition() && this.compareTo(this.getValuePosition(), b, this.getValuePosition()) == 0;
    }

    @Override
    public int hashCode() {
        return this.hashCode(this.getValuePosition());
    }

    @Override
    public int compareTo(StaticBuffer other) {
        int otherLen = other instanceof Entry ? ((Entry)other).getValuePosition() : other.length();
        return this.compareTo(this.getValuePosition(), other, otherLen);
    }

    @Override
    public String toString() {
        String s = super.toString();
        int pos = this.getValuePosition() * 4;
        return s.substring(0, pos - 1) + "->" + (this.getValuePosition() < this.length() ? s.substring(pos) : "");
    }

    @Override
    public RelationCache getCache() {
        return null;
    }

    @Override
    public void setCache(RelationCache cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMetaData() {
        return false;
    }

    @Override
    public Map<EntryMetaData, Object> getMetaData() {
        return EntryMetaData.EMPTY_METADATA;
    }
}

