/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.google.common.base.Preconditions;
import java.time.Instant;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class StandardBaseTransactionConfig
implements BaseTransactionConfig {
    private volatile Instant commitTime;
    private final TimestampProvider times;
    private final String groupName;
    private final Configuration customOptions;

    private StandardBaseTransactionConfig(String groupName, TimestampProvider times, Instant commitTime, Configuration customOptions) {
        Preconditions.checkArgument(customOptions != null);
        Preconditions.checkArgument(null != times || null != commitTime);
        this.groupName = groupName;
        this.times = times;
        this.commitTime = commitTime;
        this.customOptions = customOptions;
    }

    @Override
    public synchronized Instant getCommitTime() {
        if (this.commitTime == null) {
            this.commitTime = this.times.getTime();
        }
        return this.commitTime;
    }

    @Override
    public synchronized void setCommitTime(Instant time) {
        Preconditions.checkArgument(this.commitTime == null, "A commit time has already been set");
        this.commitTime = time;
    }

    @Override
    public boolean hasCommitTime() {
        return this.commitTime != null;
    }

    @Override
    public TimestampProvider getTimestampProvider() {
        return this.times;
    }

    @Override
    public boolean hasGroupName() {
        return this.groupName != null;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public <V> V getCustomOption(ConfigOption<V> opt) {
        return this.customOptions.get(opt, new String[0]);
    }

    @Override
    public Configuration getCustomOptions() {
        return this.customOptions;
    }

    public static StandardBaseTransactionConfig of(TimestampProvider times) {
        return new Builder().timestampProvider(times).build();
    }

    public static StandardBaseTransactionConfig of(TimestampProvider times, Configuration customOptions) {
        return new Builder().timestampProvider(times).customOptions(customOptions).build();
    }

    public static class Builder {
        private Instant commitTime = null;
        private TimestampProvider times;
        private String groupName = "org.janusgraph.sys";
        private Configuration customOptions = Configuration.EMPTY;

        public Builder() {
        }

        public Builder(BaseTransactionConfig template) {
            this.customOptions(template.getCustomOptions());
            this.groupName(template.getGroupName());
            this.timestampProvider(template.getTimestampProvider());
        }

        public Builder groupName(String group) {
            this.groupName = group;
            return this;
        }

        public Builder commitTime(Instant commit) {
            this.commitTime = commit;
            return this;
        }

        public Builder timestampProvider(TimestampProvider times) {
            this.times = times;
            return this;
        }

        public Builder customOptions(Configuration c) {
            this.customOptions = c;
            Preconditions.checkNotNull(this.customOptions, "Null custom options disallowed; use an empty Configuration object instead");
            return this;
        }

        public StandardBaseTransactionConfig build() {
            return new StandardBaseTransactionConfig(this.groupName, this.times, this.commitTime, this.customOptions);
        }
    }
}

