/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.idassigner;

import com.google.common.base.Preconditions;
import org.janusgraph.graphdb.database.idassigner.IDBlockSizer;

public class StaticIDBlockSizer
implements IDBlockSizer {
    private final long blockSize;
    private final long blockSizeLimit;

    public StaticIDBlockSizer(long blockSize, long blockSizeLimit) {
        Preconditions.checkArgument(blockSize > 0L);
        Preconditions.checkArgument(blockSizeLimit > 0L);
        Preconditions.checkArgument(blockSizeLimit > blockSize, "%s vs %s", new Object[]{blockSizeLimit, blockSize});
        this.blockSize = blockSize;
        this.blockSizeLimit = blockSizeLimit;
    }

    @Override
    public long getBlockSize(int idNamespace) {
        return this.blockSize;
    }

    @Override
    public long getIdUpperBound(int idNamespace) {
        return this.blockSizeLimit;
    }
}

