/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.management;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class RelationTypeIndexWrapper
implements RelationTypeIndex {
    public static final char RELATION_INDEX_SEPARATOR = ':';
    private final InternalRelationType type;

    public RelationTypeIndexWrapper(InternalRelationType type) {
        Preconditions.checkArgument(type != null && type.getBaseType() != null);
        this.type = type;
    }

    @Override
    public RelationType getType() {
        return this.type.getBaseType();
    }

    public InternalRelationType getWrappedType() {
        return this.type;
    }

    @Override
    public String name() {
        String typeName = this.type.name();
        int index = typeName.lastIndexOf(58);
        Preconditions.checkArgument(index > 0 && index < typeName.length() - 1, "Invalid name encountered: %s", new Object[]{typeName});
        return typeName.substring(index + 1, typeName.length());
    }

    @Override
    public Order getSortOrder() {
        return this.type.getSortOrder().getTP();
    }

    @Override
    public RelationType[] getSortKey() {
        StandardJanusGraphTx tx = this.type.tx();
        long[] ids = this.type.getSortKey();
        RelationType[] keys = new RelationType[ids.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = tx.getExistingRelationType(ids[i]);
        }
        return keys;
    }

    @Override
    public Direction getDirection() {
        if (this.type.isUnidirected(Direction.BOTH)) {
            return Direction.BOTH;
        }
        if (this.type.isUnidirected(Direction.OUT)) {
            return Direction.OUT;
        }
        if (this.type.isUnidirected(Direction.IN)) {
            return Direction.IN;
        }
        throw new AssertionError();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object oth) {
        if (oth == null) {
            return false;
        }
        if (oth == this) {
            return true;
        }
        if (!this.getClass().isInstance(oth)) {
            return false;
        }
        return this.type.equals(((RelationTypeIndexWrapper)oth).type);
    }

    @Override
    public SchemaStatus getIndexStatus() {
        return this.type.getStatus();
    }

    public String toString() {
        return this.name();
    }
}

