/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;

public class ShortSerializer
implements OrderPreservingSerializer<Short> {
    private static final long serialVersionUID = 117423419862504186L;

    @Override
    public Short read(ScanBuffer buffer) {
        return (short)(buffer.getShort() + Short.MIN_VALUE);
    }

    @Override
    public void write(WriteBuffer out, Short object) {
        out.putShort((short)(object - Short.MIN_VALUE));
    }

    @Override
    public Short readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Short attribute) {
        this.write(buffer, attribute);
    }

    @Override
    public Short convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            Preconditions.checkArgument(!Double.isNaN(d) && (double)Math.round(d) == d, "Not a valid short: " + value);
            long l = ((Number)value).longValue();
            Preconditions.checkArgument(l >= -32768L && l <= 32767L, "Value too large for short: " + value);
            return (short)l;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        return null;
    }
}

