/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;

public class UUIDSerializer
implements OrderPreservingSerializer<UUID> {
    @Override
    public UUID read(ScanBuffer buffer) {
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Override
    public void write(WriteBuffer buffer, UUID attribute) {
        buffer.putLong(attribute.getMostSignificantBits());
        buffer.putLong(attribute.getLeastSignificantBits());
    }

    @Override
    public UUID convert(Object value) {
        Preconditions.checkNotNull(value);
        if (value instanceof String) {
            return UUID.fromString((String)value);
        }
        return null;
    }

    @Override
    public UUID readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, UUID attribute) {
        this.write(buffer, attribute);
    }
}

