/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.idmanagement;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.core.JanusGraphConfigurationException;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.encoding.LongEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueInstanceIdRetriever {
    private static final Logger log = LoggerFactory.getLogger(UniqueInstanceIdRetriever.class);
    private static UniqueInstanceIdRetriever uniqueInstanceIdGenerator;
    private final AtomicLong instanceCounter = new AtomicLong(0L);

    private UniqueInstanceIdRetriever() {
    }

    public static UniqueInstanceIdRetriever getInstance() {
        if (uniqueInstanceIdGenerator == null) {
            uniqueInstanceIdGenerator = new UniqueInstanceIdRetriever();
        }
        return uniqueInstanceIdGenerator;
    }

    public String getOrGenerateUniqueInstanceId(Configuration config) {
        String uid;
        if (!config.has(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0])) {
            uid = this.computeUniqueInstanceId(config);
            log.info("Generated {}={}", (Object)GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID.getName(), (Object)uid);
        } else {
            uid = config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0]);
        }
        Preconditions.checkArgument(!StringUtils.containsAny(uid, ConfigElement.ILLEGAL_CHARS), "Invalid unique identifier: %s", new Object[]{uid});
        return uid;
    }

    private String computeUniqueInstanceId(Configuration config) {
        String suffix = this.getSuffix(config);
        String uid = this.getUid(config);
        String instanceId = uid + suffix;
        for (char c : ConfigElement.ILLEGAL_CHARS) {
            instanceId = StringUtils.replaceChars(instanceId, c, '-');
        }
        return instanceId;
    }

    private String getSuffix(Configuration config) {
        String suffix = config.has(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_SUFFIX, new String[0]) ? LongEncoding.encode(config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_SUFFIX, new String[0]).shortValue()) : (!config.has(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME, new String[0]) ? ManagementFactory.getRuntimeMXBean().getName() + LongEncoding.encode(this.instanceCounter.incrementAndGet()) : "");
        return suffix;
    }

    private String getUid(Configuration config) {
        String uid;
        InetAddress localHost;
        try {
            localHost = Inet4Address.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new JanusGraphConfigurationException("Cannot determine local host", e);
        }
        if (config.has(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME, new String[0]) && config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME, new String[0]).booleanValue()) {
            uid = localHost.getHostName();
        } else {
            byte[] addrBytes = localHost.getAddress();
            uid = new String(Hex.encodeHex(addrBytes));
        }
        return uid;
    }
}

