/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.log;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.log.Change;
import org.janusgraph.core.log.ChangeState;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalVertex;

class StandardChangeState
implements ChangeState {
    private final EnumMap<Change, Set<JanusGraphVertex>> vertices = new EnumMap(Change.class);
    private final EnumMap<Change, Set<JanusGraphRelation>> relations = new EnumMap(Change.class);

    StandardChangeState() {
        for (Change state : new Change[]{Change.ADDED, Change.REMOVED}) {
            this.vertices.put(state, new HashSet());
            this.relations.put(state, new HashSet());
        }
    }

    void addVertex(InternalVertex vertex, Change state) {
        this.vertices.get((Object)state).add(vertex);
    }

    void addRelation(InternalRelation rel, Change state) {
        this.relations.get((Object)state).add(rel);
    }

    @Override
    public Set<JanusGraphVertex> getVertices(Change change) {
        if (change.isProper()) {
            return this.vertices.get((Object)change);
        }
        assert (change == Change.ANY);
        HashSet<JanusGraphVertex> all = new HashSet<JanusGraphVertex>();
        for (Change state : new Change[]{Change.ADDED, Change.REMOVED}) {
            all.addAll((Collection<JanusGraphVertex>)this.vertices.get((Object)state));
            for (JanusGraphRelation rel : this.relations.get((Object)state)) {
                InternalRelation internalRelation = (InternalRelation)rel;
                for (int p = 0; p < internalRelation.getLen(); ++p) {
                    all.add(internalRelation.getVertex(p));
                }
            }
        }
        return all;
    }

    private <T> Set<T> toSet(T ... types) {
        if (types == null || types.length == 0) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(types);
    }

    private Iterable<JanusGraphRelation> getRelations(Change change, Predicate<JanusGraphRelation> filter) {
        Iterable base = change.isProper() ? (Iterable)this.relations.get((Object)change) : Iterables.concat((Iterable)this.relations.get((Object)Change.ADDED), (Iterable)this.relations.get((Object)Change.REMOVED));
        return Iterables.filter(base, filter);
    }

    @Override
    public Iterable<JanusGraphRelation> getRelations(Change change, RelationType ... types) {
        Set<RelationType> typeSet = this.toSet(types);
        return this.getRelations(change, janusgraphRelation -> typeSet.isEmpty() || typeSet.contains(janusgraphRelation.getType()));
    }

    @Override
    public Iterable<JanusGraphEdge> getEdges(Vertex vertex, Change change, Direction dir, String ... labels) {
        Set<String> stypes = this.toSet(labels);
        return this.getRelations(change, janusgraphRelation -> !(!janusgraphRelation.isEdge() || !janusgraphRelation.isIncidentOn(vertex) || dir != Direction.BOTH && !((JanusGraphEdge)janusgraphRelation).vertex(dir).equals(vertex) || !stypes.isEmpty() && !stypes.contains(janusgraphRelation.getType().name())));
    }

    @Override
    public Iterable<JanusGraphVertexProperty> getProperties(Vertex vertex, Change change, String ... keys) {
        Set<String> stypes = this.toSet(keys);
        return this.getRelations(change, janusgraphRelation -> janusgraphRelation.isProperty() && janusgraphRelation.isIncidentOn(vertex) && (stypes.isEmpty() || stypes.contains(janusgraphRelation.getType().name())));
    }
}

