/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.log;

import com.google.common.base.Preconditions;
import java.time.Instant;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.janusgraph.core.log.TransactionId;

public class StandardTransactionId
implements TransactionId {
    private final String instanceId;
    private final long transactionId;
    private final Instant transactionTime;

    public StandardTransactionId(String instanceId, long transactionId, Instant transactionTime) {
        Preconditions.checkArgument(instanceId != null && transactionId >= 0L && transactionTime != null);
        this.instanceId = instanceId;
        this.transactionId = transactionId;
        this.transactionTime = transactionTime;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Instant getTransactionTime() {
        return this.transactionTime;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.instanceId).append(this.transactionId).append(this.transactionTime).toHashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        StandardTransactionId id = (StandardTransactionId)oth;
        return this.instanceId.equals(id.instanceId) && this.transactionId == id.transactionId && this.transactionTime.equals(id.transactionTime);
    }

    public String toString() {
        return this.transactionId + "@" + this.instanceId + "::" + this.transactionTime;
    }
}

