/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;

public class FulgoraReduceEmitter<OK, OV>
implements MapReduce.ReduceEmitter<OK, OV> {
    protected final Queue<KeyValue<OK, OV>> reduceQueue = new ConcurrentLinkedQueue<KeyValue<OK, OV>>();

    @Override
    public void emit(OK key, OV value) {
        this.reduceQueue.add(new KeyValue<OK, OV>(key, value));
    }

    protected void complete(MapReduce<?, ?, OK, OV, ?> mapReduce) {
        if (mapReduce.getReduceKeySort().isPresent()) {
            Comparator<OK> comparator = mapReduce.getReduceKeySort().get();
            ArrayList<KeyValue<OK, OV>> list = new ArrayList<KeyValue<OK, OV>>(this.reduceQueue);
            list.sort(Comparator.comparing(KeyValue::getKey, comparator));
            this.reduceQueue.clear();
            this.reduceQueue.addAll(list);
        }
    }
}

