/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.query.condition.Literal;

public class IncidenceDirectionCondition<E extends JanusGraphRelation>
extends Literal<E> {
    private final Direction direction;
    private final JanusGraphVertex otherVertex;

    public IncidenceDirectionCondition(Direction direction, JanusGraphVertex otherVertex) {
        Preconditions.checkNotNull(direction);
        Preconditions.checkNotNull(otherVertex);
        this.direction = direction;
        this.otherVertex = otherVertex;
    }

    @Override
    public boolean evaluate(E relation) {
        return relation.isEdge() && ((JanusGraphEdge)relation).vertex(this.direction).equals(this.otherVertex);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.direction).append(this.otherVertex).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        IncidenceDirectionCondition oth = (IncidenceDirectionCondition)other;
        return this.direction == oth.direction && this.otherVertex.equals(oth.otherVertex);
    }

    @Override
    public String toString() {
        return "incidence[" + (Object)((Object)this.direction) + "-" + this.otherVertex + "]";
    }
}

