/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.Literal;
import org.janusgraph.graphdb.util.ElementHelper;

public class PredicateCondition<K, E extends JanusGraphElement>
extends Literal<E> {
    private final K key;
    private final JanusGraphPredicate predicate;
    private final Object value;

    public PredicateCondition(K key, JanusGraphPredicate predicate, Object value) {
        Preconditions.checkArgument(key instanceof String || key instanceof RelationType);
        this.key = key;
        this.predicate = Preconditions.checkNotNull(predicate);
        this.value = value;
    }

    private boolean satisfiesCondition(Object value) {
        return this.predicate.test(value, this.value);
    }

    @Override
    public boolean evaluate(E element) {
        RelationType type;
        if (this.key instanceof String) {
            type = ((InternalElement)element).tx().getRelationType((String)this.key);
            if (type == null) {
                return this.satisfiesCondition(null);
            }
        } else {
            type = (RelationType)this.key;
        }
        Preconditions.checkNotNull(type);
        if (type.isPropertyKey()) {
            Iterator<Object> iterator = ElementHelper.getValues(element, (PropertyKey)type).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (!this.satisfiesCondition(iterator.next())) continue;
                    return true;
                }
                return false;
            }
            return this.satisfiesCondition(null);
        }
        assert (((InternalRelationType)type).multiplicity().isUnique(Direction.OUT));
        return this.satisfiesCondition(element.value(type.name()));
    }

    public K getKey() {
        return this.key;
    }

    public JanusGraphPredicate getPredicate() {
        return this.predicate;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append(this.key).append(this.predicate).append(this.value).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        PredicateCondition oth = (PredicateCondition)other;
        return this.key.equals(oth.key) && this.predicate.equals(oth.predicate) && this.value.equals(oth.value);
    }

    @Override
    public String toString() {
        return this.key.toString() + " " + this.predicate.toString() + " " + String.valueOf(this.value);
    }

    public static <K, E extends JanusGraphElement> PredicateCondition<K, E> of(K key, JanusGraphPredicate janusgraphPredicate, Object condition) {
        return new PredicateCondition<K, E>(key, janusgraphPredicate, condition);
    }
}

