/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.BaseQuery;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.util.StreamIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexQueryBuilder
extends BaseQuery
implements JanusGraphIndexQuery {
    private static final Logger log = LoggerFactory.getLogger(IndexQueryBuilder.class);
    private static final String VERTEX_PREFIX = "v.";
    private static final String EDGE_PREFIX = "e.";
    private static final String PROPERTY_PREFIX = "p.";
    private final StandardJanusGraphTx tx;
    private final IndexSerializer serializer;
    private String indexName;
    private String query;
    private final List<Parameter<Order>> orders;
    private final List<Parameter> parameters;
    private String prefix;
    private final String unknownKeyName;
    private int offset;

    public IndexQueryBuilder(StandardJanusGraphTx tx, IndexSerializer serializer) {
        Preconditions.checkNotNull(tx);
        Preconditions.checkNotNull(serializer);
        this.tx = tx;
        this.serializer = serializer;
        this.parameters = Lists.newArrayList();
        this.orders = Lists.newArrayList();
        this.unknownKeyName = tx.getGraph().getConfiguration().getUnknownIndexKeyName();
        this.offset = 0;
    }

    public String getIndex() {
        return this.indexName;
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[0]);
    }

    public String getQuery() {
        return this.query;
    }

    public ImmutableList<Parameter<Order>> getOrders() {
        return ImmutableList.copyOf(this.orders);
    }

    public int getOffset() {
        return this.offset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public IndexQueryBuilder setElementIdentifier(String identifier) {
        Preconditions.checkArgument(StringUtils.isNotBlank(identifier), "Prefix may not be a blank string");
        this.prefix = identifier;
        return this;
    }

    public String getUnknownKeyName() {
        return this.unknownKeyName;
    }

    public IndexQueryBuilder setIndex(String indexName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(indexName));
        this.indexName = indexName;
        return this;
    }

    public IndexQueryBuilder setQuery(String query) {
        Preconditions.checkArgument(StringUtils.isNotBlank(query));
        this.query = query;
        return this;
    }

    @Override
    public IndexQueryBuilder offset(int offset) {
        Preconditions.checkArgument(offset >= 0, "Invalid offset provided: %s", new Object[]{offset});
        this.offset = offset;
        return this;
    }

    @Override
    public JanusGraphIndexQuery orderBy(String key, Order order) {
        Preconditions.checkArgument(key != null && order != null, "Need to specify and key and an order");
        this.orders.add(Parameter.of(key, order));
        return this;
    }

    @Override
    public IndexQueryBuilder limit(int limit) {
        super.setLimit(limit);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameter(Parameter para) {
        this.parameters.add(para);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameters(Iterable<Parameter> paras) {
        Iterables.addAll(this.parameters, paras);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameters(Parameter ... paras) {
        for (Parameter para : paras) {
            this.addParameter(para);
        }
        return this;
    }

    private <E extends JanusGraphElement> Stream<JanusGraphIndexQuery.Result<E>> execute(ElementCategory resultType, Class<E> resultClass) {
        Preconditions.checkNotNull(this.indexName);
        Preconditions.checkNotNull(this.query);
        if (this.tx.hasModifications()) {
            log.warn("Modifications in this transaction might not be accurately reflected in this index query: {}", (Object)this.query);
        }
        return this.serializer.executeQuery(this, resultType, this.tx.getTxHandle(), this.tx).map(r -> new ResultImpl(this.tx.getConversionFunction(resultType).apply(r.getResult()), r.getScore(), null)).filter(r -> !((JanusGraphElement)r.getElement()).isRemoved());
    }

    private Long executeTotals(ElementCategory resultType) {
        Preconditions.checkNotNull(this.indexName);
        Preconditions.checkNotNull(this.query);
        this.setLimit(0);
        if (this.tx.hasModifications()) {
            log.warn("Modifications in this transaction might not be accurately reflected in this index query: {}", (Object)this.query);
        }
        return this.serializer.executeTotals(this, resultType, this.tx.getTxHandle(), this.tx);
    }

    @Override
    @Deprecated
    public Iterable<JanusGraphIndexQuery.Result<JanusGraphVertex>> vertices() {
        return new StreamIterable<JanusGraphIndexQuery.Result<JanusGraphVertex>>(this.vertexStream());
    }

    @Override
    public Stream<JanusGraphIndexQuery.Result<JanusGraphVertex>> vertexStream() {
        this.setPrefixInternal(VERTEX_PREFIX);
        return this.execute(ElementCategory.VERTEX, JanusGraphVertex.class);
    }

    @Override
    @Deprecated
    public Iterable<JanusGraphIndexQuery.Result<JanusGraphEdge>> edges() {
        return new StreamIterable<JanusGraphIndexQuery.Result<JanusGraphEdge>>(this.edgeStream());
    }

    @Override
    public Stream<JanusGraphIndexQuery.Result<JanusGraphEdge>> edgeStream() {
        this.setPrefixInternal(EDGE_PREFIX);
        return this.execute(ElementCategory.EDGE, JanusGraphEdge.class);
    }

    @Override
    @Deprecated
    public Iterable<JanusGraphIndexQuery.Result<JanusGraphVertexProperty>> properties() {
        return new StreamIterable<JanusGraphIndexQuery.Result<JanusGraphVertexProperty>>(this.propertyStream());
    }

    @Override
    public Stream<JanusGraphIndexQuery.Result<JanusGraphVertexProperty>> propertyStream() {
        this.setPrefixInternal(PROPERTY_PREFIX);
        return this.execute(ElementCategory.PROPERTY, JanusGraphVertexProperty.class);
    }

    @Override
    public Long vertexTotals() {
        this.setPrefixInternal(VERTEX_PREFIX);
        return this.executeTotals(ElementCategory.VERTEX);
    }

    @Override
    public Long edgeTotals() {
        this.setPrefixInternal(EDGE_PREFIX);
        return this.executeTotals(ElementCategory.EDGE);
    }

    @Override
    public Long propertyTotals() {
        this.setPrefixInternal(PROPERTY_PREFIX);
        return this.executeTotals(ElementCategory.PROPERTY);
    }

    private void setPrefixInternal(String prefix) {
        Preconditions.checkArgument(StringUtils.isNotBlank(prefix));
        if (this.prefix == null) {
            this.prefix = prefix;
        }
    }

    private static class ResultImpl<V extends Element>
    implements JanusGraphIndexQuery.Result<V> {
        private final V element;
        private final double score;

        private ResultImpl(V element, double score) {
            this.element = element;
            this.score = score;
        }

        @Override
        public V getElement() {
            return this.element;
        }

        @Override
        public double getScore() {
            return this.score;
        }

        /* synthetic */ ResultImpl(Element x0, double x1, 1 x2) {
            this(x0, x1);
        }
    }
}

