/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.graphdb.query.BackendQuery;
import org.janusgraph.graphdb.query.BaseQuery;
import org.janusgraph.graphdb.query.graph.MultiKeySliceQuery;
import org.janusgraph.graphdb.query.profile.ProfileObservable;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;

public class JointIndexQuery
extends BaseQuery
implements BackendQuery<JointIndexQuery>,
ProfileObservable {
    private final List<Subquery> queries;

    private JointIndexQuery(List<Subquery> queries) {
        this.queries = Preconditions.checkNotNull(queries);
    }

    public JointIndexQuery() {
        this.queries = new ArrayList<Subquery>(4);
    }

    public void add(MixedIndexType index, IndexQuery query) {
        this.queries.add(new Subquery(index, query));
    }

    public void add(CompositeIndexType index, MultiKeySliceQuery query) {
        this.queries.add(new Subquery(index, query));
    }

    public int size() {
        return this.queries.size();
    }

    public Subquery getQuery(int pos) {
        return this.queries.get(pos);
    }

    public boolean isEmpty() {
        return this.queries.isEmpty();
    }

    @Override
    public void observeWith(QueryProfiler profiler) {
        this.queries.forEach(q -> q.observeWith(profiler));
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.queries).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        JointIndexQuery oth = (JointIndexQuery)other;
        return oth.queries.equals(this.queries);
    }

    public String toString() {
        return this.queries.toString();
    }

    @Override
    public JointIndexQuery updateLimit(int newLimit) {
        JointIndexQuery ji = new JointIndexQuery(Lists.newArrayList(this.queries));
        ji.setLimit(newLimit);
        return ji;
    }

    public static class Subquery
    implements BackendQuery<Subquery>,
    ProfileObservable {
        private final IndexType index;
        private final BackendQuery query;
        private QueryProfiler profiler = QueryProfiler.NO_OP;

        private Subquery(IndexType index, BackendQuery query) {
            assert (index != null && query != null && (query instanceof MultiKeySliceQuery || query instanceof IndexQuery));
            this.index = index;
            this.query = query;
        }

        @Override
        public void observeWith(QueryProfiler prof) {
            this.profiler = prof.addNested("AND-query");
            this.profiler.setAnnotation("query", this.query);
            this.profiler.setAnnotation("index", this.index.getName());
            if (this.index.isMixedIndex()) {
                this.profiler.setAnnotation("index_impl", this.index.getBackingIndexName());
            }
        }

        public QueryProfiler getProfiler() {
            return this.profiler;
        }

        public IndexType getIndex() {
            return this.index;
        }

        public IndexQuery getMixedQuery() {
            Preconditions.checkArgument(this.index.isMixedIndex() && this.query instanceof IndexQuery);
            return (IndexQuery)this.query;
        }

        public MultiKeySliceQuery getCompositeQuery() {
            Preconditions.checkArgument(this.index.isCompositeIndex() && this.query instanceof MultiKeySliceQuery);
            return (MultiKeySliceQuery)this.query;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.index).append(this.query).toHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!this.getClass().isInstance(other)) {
                return false;
            }
            Subquery oth = (Subquery)other;
            return this.index.equals(oth.index) && this.query.equals(oth.query);
        }

        public String toString() {
            return this.index.toString() + ":" + this.query.toString();
        }

        @Override
        public Subquery updateLimit(int newLimit) {
            return new Subquery(this.index, (BackendQuery)this.query.updateLimit(newLimit));
        }

        @Override
        public boolean hasLimit() {
            return this.query.hasLimit();
        }

        @Override
        public int getLimit() {
            return this.query.getLimit();
        }
    }
}

