/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.ElementQuery;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.vertex.BaseVertexCentricQuery;
import org.janusgraph.graphdb.relations.RelationComparator;

public class VertexCentricQuery
extends BaseVertexCentricQuery
implements ElementQuery<JanusGraphRelation, SliceQuery> {
    private final InternalVertex vertex;

    public VertexCentricQuery(InternalVertex vertex, Condition<JanusGraphRelation> condition, Direction direction, List<BackendQueryHolder<SliceQuery>> queries, OrderList orders, int limit) {
        super(condition, direction, queries, orders, limit);
        Preconditions.checkNotNull(vertex);
        this.vertex = vertex;
    }

    public VertexCentricQuery(InternalVertex vertex, BaseVertexCentricQuery base) {
        super(base);
        Preconditions.checkNotNull(vertex);
        this.vertex = vertex;
    }

    protected VertexCentricQuery(InternalVertex vertex) {
        Preconditions.checkNotNull(vertex);
        this.vertex = vertex;
    }

    public static VertexCentricQuery emptyQuery(InternalVertex vertex) {
        return new VertexCentricQuery(vertex);
    }

    public InternalVertex getVertex() {
        return this.vertex;
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public Comparator getSortOrder() {
        return new RelationComparator(this.vertex, this.getOrders());
    }

    @Override
    public boolean hasDuplicateResults() {
        return false;
    }

    @Override
    public String toString() {
        return this.vertex + super.toString();
    }
}

