/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.AbstractTypedRelation;

public abstract class AbstractVertexProperty<V>
extends AbstractTypedRelation
implements JanusGraphVertexProperty<V> {
    private InternalVertex vertex;
    private final Object value;

    public AbstractVertexProperty(long id, PropertyKey type, InternalVertex vertex, Object value) {
        super(id, type);
        this.vertex = Preconditions.checkNotNull(vertex, "null vertex");
        this.value = Preconditions.checkNotNull(value, "null value for property key %s", new Object[]{type});
    }

    public String toString() {
        return StringFactory.propertyString(this);
    }

    public void setVertexAt(int pos, InternalVertex vertex) {
        Preconditions.checkArgument(pos == 0 && vertex != null && this.vertex.equals(vertex));
        this.vertex = vertex;
    }

    @Override
    public InternalVertex getVertex(int pos) {
        if (pos == 0) {
            return this.vertex;
        }
        throw new IllegalArgumentException("Invalid position: " + pos);
    }

    @Override
    public JanusGraphTransaction graph() {
        return this.vertex.graph();
    }

    @Override
    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        return super.properties(propertyKeys);
    }

    @Override
    public final int getArity() {
        return 1;
    }

    @Override
    public final int getLen() {
        return 1;
    }

    @Override
    public JanusGraphVertex element() {
        return this.vertex;
    }

    @Override
    public V value() {
        return (V)this.value;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public boolean isEdge() {
        return false;
    }

    @Override
    public boolean isPresent() {
        return true;
    }
}

