/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.relations.StandardRelation;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.util.encoding.LongEncoding;

public final class RelationIdentifier
implements Serializable {
    public static final String TOSTRING_DELIMITER = "-";
    private final long outVertexId;
    private final long typeId;
    private final long relationId;
    private final long inVertexId;

    private RelationIdentifier() {
        this.outVertexId = 0L;
        this.typeId = 0L;
        this.relationId = 0L;
        this.inVertexId = 0L;
    }

    private RelationIdentifier(long outVertexId, long typeId, long relationId, long inVertexId) {
        this.outVertexId = outVertexId;
        this.typeId = typeId;
        this.relationId = relationId;
        this.inVertexId = inVertexId;
    }

    static RelationIdentifier get(InternalRelation r) {
        if (r.hasId()) {
            return new RelationIdentifier(r.getVertex(0).longId(), r.getType().longId(), r.longId(), r.isEdge() ? r.getVertex(1).longId() : 0L);
        }
        return null;
    }

    public long getRelationId() {
        return this.relationId;
    }

    public long getTypeId() {
        return this.typeId;
    }

    public long getOutVertexId() {
        return this.outVertexId;
    }

    public long getInVertexId() {
        Preconditions.checkState(this.inVertexId != 0L);
        return this.inVertexId;
    }

    public static RelationIdentifier get(long[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0L) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? ids[3] : 0L);
    }

    public static RelationIdentifier get(int[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? (long)ids[3] : 0L);
    }

    public long[] getLongRepresentation() {
        long[] r = new long[3 + (this.inVertexId != 0L ? 1 : 0)];
        r[0] = this.relationId;
        r[1] = this.outVertexId;
        r[2] = this.typeId;
        if (this.inVertexId != 0L) {
            r[3] = this.inVertexId;
        }
        return r;
    }

    public int hashCode() {
        return Long.valueOf(this.relationId).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        RelationIdentifier oth = (RelationIdentifier)other;
        return this.relationId == oth.relationId && this.typeId == oth.typeId;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(LongEncoding.encode(this.relationId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.outVertexId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.typeId));
        if (this.inVertexId != 0L) {
            s.append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.inVertexId));
        }
        return s.toString();
    }

    public static RelationIdentifier parse(String id) {
        String[] elements = id.split(TOSTRING_DELIMITER);
        if (elements.length != 3 && elements.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + id);
        }
        try {
            return new RelationIdentifier(LongEncoding.decode(elements[1]), LongEncoding.decode(elements[2]), LongEncoding.decode(elements[0]), elements.length == 4 ? LongEncoding.decode(elements[3]) : 0L);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid id - each token expected to be a number", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    JanusGraphRelation findRelation(JanusGraphTransaction tx) {
        Iterable<JanusGraphRelation> relations;
        InternalVertex v = ((StandardJanusGraphTx)tx).getInternalVertex(this.outVertexId);
        if (v == null || v.isRemoved()) {
            return null;
        }
        JanusGraphVertex typeVertex = tx.getVertex(this.typeId);
        if (typeVertex == null) {
            return null;
        }
        if (!(typeVertex instanceof RelationType)) {
            throw new IllegalArgumentException("Invalid RelationIdentifier: typeID does not reference a type");
        }
        RelationType type = (RelationType)typeVertex;
        if (((RelationType)typeVertex).isEdgeLabel()) {
            void var7_8;
            Direction dir = Direction.OUT;
            InternalVertex internalVertex = ((StandardJanusGraphTx)tx).getInternalVertex(this.inVertexId);
            if (internalVertex == null || internalVertex.isRemoved()) {
                return null;
            }
            if (((StandardJanusGraphTx)tx).isPartitionedVertex(v) && !((StandardJanusGraphTx)tx).isPartitionedVertex(internalVertex)) {
                InternalVertex tmp = internalVertex;
                InternalVertex internalVertex2 = v;
                v = tmp;
                dir = Direction.IN;
            }
            relations = ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)v.query()).noPartitionRestriction()).types((EdgeLabel)type)).direction(dir)).adjacent((Vertex)var7_8)).edges();
        } else {
            relations = ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)v.query()).noPartitionRestriction()).types((PropertyKey)type)).properties();
        }
        for (JanusGraphRelation janusGraphRelation : relations) {
            if (janusGraphRelation.longId() != this.relationId && (!(janusGraphRelation instanceof StandardRelation) || ((StandardRelation)janusGraphRelation).getPreviousID() != this.relationId)) continue;
            return janusGraphRelation;
        }
        return null;
    }

    public JanusGraphEdge findEdge(JanusGraphTransaction tx) {
        JanusGraphRelation r = this.findRelation(tx);
        if (r == null) {
            return null;
        }
        if (r instanceof JanusGraphEdge) {
            return (JanusGraphEdge)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a property not an edge");
    }

    public JanusGraphVertexProperty findProperty(JanusGraphTransaction tx) {
        JanusGraphRelation r = this.findRelation(tx);
        if (r == null) {
            return null;
        }
        if (r instanceof JanusGraphVertexProperty) {
            return (JanusGraphVertexProperty)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a edge not a property");
    }
}

