/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.internal.InternalRelation;

public class SimpleJanusGraphProperty<V>
implements JanusGraphProperty<V> {
    private final PropertyKey key;
    private final V value;
    private final InternalRelation relation;

    public SimpleJanusGraphProperty(InternalRelation relation, PropertyKey key, V value) {
        this.key = key;
        this.value = value;
        this.relation = relation;
    }

    @Override
    public PropertyKey propertyKey() {
        return this.key;
    }

    @Override
    public V value() throws NoSuchElementException {
        return this.value;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public JanusGraphElement element() {
        return this.relation;
    }

    @Override
    public void remove() {
        Preconditions.checkArgument(!this.relation.isRemoved(), "Cannot modified removed relation");
        this.relation.it().removePropertyDirect(this.key);
    }

    public String toString() {
        return StringFactory.propertyString(this);
    }

    public int hashCode() {
        return ElementHelper.hashCode(this);
    }

    public boolean equals(Object oth) {
        return ElementHelper.areEqual(this, oth);
    }
}

