/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;

public class JanusGraphVariables
implements Graph.Variables {
    private final WriteConfiguration config;

    public JanusGraphVariables(WriteConfiguration config) {
        this.config = config;
    }

    @Override
    public Set<String> keys() {
        return Sets.newHashSet(this.config.getKeys(""));
    }

    @Override
    public <R> Optional<R> get(String s) {
        if (s == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (StringUtils.isEmpty(s)) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        Object value = this.config.get(s, Object.class);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @Override
    public void set(String s, Object o) {
        if (s == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (StringUtils.isEmpty(s)) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        if (o == null) {
            throw Graph.Variables.Exceptions.variableValueCanNotBeNull();
        }
        this.config.set(s, o);
    }

    @Override
    public void remove(String s) {
        if (s == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (StringUtils.isEmpty(s)) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        this.config.remove(s);
    }

    public String toString() {
        return StringFactory.graphVariablesString(this);
    }
}

