/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction;

import com.google.common.base.Preconditions;
import java.time.Instant;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.TransactionBuilder;
import org.janusgraph.core.schema.DefaultSchemaMaker;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.MergedConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;

public class StandardTransactionBuilder
implements TransactionConfiguration,
TransactionBuilder {
    private boolean isReadOnly = false;
    private boolean hasEnabledBatchLoading = false;
    private final boolean assignIDsImmediately;
    private boolean preloadedData = false;
    private final DefaultSchemaMaker defaultSchemaMaker;
    private boolean hasDisabledSchemaConstraints = true;
    private boolean verifyExternalVertexExistence = true;
    private boolean verifyInternalVertexExistence = false;
    private boolean verifyUniqueness = true;
    private boolean acquireLocks = true;
    private final boolean propertyPrefetching;
    private boolean singleThreaded = false;
    private boolean threadBound = false;
    private int vertexCacheSize;
    private int dirtyVertexSize;
    private long indexCacheWeight;
    private String logIdentifier;
    private int[] restrictedPartitions = new int[0];
    private Instant userCommitTime = null;
    private String groupName;
    private final boolean forceIndexUsage;
    private final ModifiableConfiguration writableCustomOptions;
    private final Configuration customOptions;
    private final StandardJanusGraph graph;

    public StandardTransactionBuilder(GraphDatabaseConfiguration graphConfig, StandardJanusGraph graph) {
        Preconditions.checkNotNull(graphConfig);
        Preconditions.checkNotNull(graph);
        if (graphConfig.isReadOnly()) {
            this.readOnly();
        }
        if (graphConfig.isBatchLoading()) {
            this.enableBatchLoading();
        }
        this.graph = graph;
        this.defaultSchemaMaker = graphConfig.getDefaultSchemaMaker();
        this.hasDisabledSchemaConstraints = graphConfig.hasDisabledSchemaConstraints();
        this.assignIDsImmediately = graphConfig.hasFlushIDs();
        this.forceIndexUsage = graphConfig.hasForceIndexUsage();
        this.groupName = graphConfig.getMetricsPrefix();
        this.logIdentifier = null;
        this.propertyPrefetching = graphConfig.hasPropertyPrefetching();
        this.writableCustomOptions = GraphDatabaseConfiguration.buildGraphConfiguration();
        this.customOptions = new MergedConfiguration(this.writableCustomOptions, graphConfig.getConfiguration());
        this.vertexCacheSize(graphConfig.getTxVertexCacheSize());
        this.dirtyVertexSize(graphConfig.getTxDirtyVertexSize());
    }

    public StandardTransactionBuilder(GraphDatabaseConfiguration graphConfig, StandardJanusGraph graph, Configuration customOptions) {
        Preconditions.checkNotNull(graphConfig);
        Preconditions.checkNotNull(graph);
        if (graphConfig.isReadOnly()) {
            this.readOnly();
        }
        if (graphConfig.isBatchLoading()) {
            this.enableBatchLoading();
        }
        this.graph = graph;
        this.defaultSchemaMaker = graphConfig.getDefaultSchemaMaker();
        this.hasDisabledSchemaConstraints = graphConfig.hasDisabledSchemaConstraints();
        this.assignIDsImmediately = graphConfig.hasFlushIDs();
        this.forceIndexUsage = graphConfig.hasForceIndexUsage();
        this.groupName = graphConfig.getMetricsPrefix();
        this.logIdentifier = null;
        this.propertyPrefetching = graphConfig.hasPropertyPrefetching();
        this.writableCustomOptions = null;
        this.customOptions = customOptions;
        this.vertexCacheSize(graphConfig.getTxVertexCacheSize());
        this.dirtyVertexSize(graphConfig.getTxDirtyVertexSize());
    }

    public StandardTransactionBuilder threadBound() {
        this.threadBound = true;
        this.singleThreaded = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder readOnly() {
        this.isReadOnly = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder enableBatchLoading() {
        this.hasEnabledBatchLoading = true;
        this.checkExternalVertexExistence(false);
        this.consistencyChecks(false);
        return this;
    }

    @Override
    public StandardTransactionBuilder disableBatchLoading() {
        this.hasEnabledBatchLoading = false;
        this.checkExternalVertexExistence(true);
        this.consistencyChecks(true);
        return this;
    }

    @Override
    public StandardTransactionBuilder vertexCacheSize(int size) {
        Preconditions.checkArgument(size >= 0);
        this.vertexCacheSize = size;
        this.indexCacheWeight = size / 2;
        return this;
    }

    @Override
    public TransactionBuilder dirtyVertexSize(int size) {
        this.dirtyVertexSize = size;
        return this;
    }

    @Override
    public StandardTransactionBuilder checkInternalVertexExistence(boolean enabled) {
        this.verifyInternalVertexExistence = enabled;
        return this;
    }

    @Override
    public StandardTransactionBuilder checkExternalVertexExistence(boolean enabled) {
        this.verifyExternalVertexExistence = enabled;
        return this;
    }

    @Override
    public TransactionBuilder consistencyChecks(boolean enabled) {
        this.verifyUniqueness = enabled;
        this.acquireLocks = enabled;
        return this;
    }

    @Override
    public StandardTransactionBuilder commitTime(Instant timestampSinceEpoch) {
        this.userCommitTime = timestampSinceEpoch;
        return this;
    }

    @Override
    public void setCommitTime(Instant time) {
        throw new UnsupportedOperationException("Use setCommitTime(long,TimeUnit)");
    }

    @Override
    public StandardTransactionBuilder groupName(String p) {
        this.groupName = p;
        return this;
    }

    @Override
    public StandardTransactionBuilder logIdentifier(String logName) {
        this.logIdentifier = logName;
        return this;
    }

    @Override
    public TransactionBuilder restrictedPartitions(int[] partitions) {
        Preconditions.checkNotNull(partitions);
        this.restrictedPartitions = partitions;
        return this;
    }

    public TransactionBuilder setPreloadedData(boolean preloaded) {
        this.preloadedData = preloaded;
        return this;
    }

    @Override
    public TransactionBuilder customOption(String k, Object v) {
        if (null == this.writableCustomOptions) {
            throw new IllegalStateException("This builder was not constructed with setCustomOption support");
        }
        this.writableCustomOptions.set((ConfigOption)ConfigElement.parse((ConfigNamespace)GraphDatabaseConfiguration.ROOT_NS, (String)k).element, v, new String[0]);
        return this;
    }

    @Override
    public JanusGraphTransaction start() {
        ImmutableTxCfg immutable = new ImmutableTxCfg(this.isReadOnly, this.hasEnabledBatchLoading, this.assignIDsImmediately, this.preloadedData, this.forceIndexUsage, this.verifyExternalVertexExistence, this.verifyInternalVertexExistence, this.acquireLocks, this.verifyUniqueness, this.propertyPrefetching, this.singleThreaded, this.threadBound, this.getTimestampProvider(), this.userCommitTime, this.indexCacheWeight, this.getVertexCacheSize(), this.getDirtyVertexSize(), this.logIdentifier, this.restrictedPartitions, this.groupName, this.defaultSchemaMaker, this.hasDisabledSchemaConstraints, this.customOptions);
        return this.graph.newTransaction(immutable);
    }

    @Override
    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public final boolean hasAssignIDsImmediately() {
        return this.assignIDsImmediately;
    }

    @Override
    public boolean hasPreloadedData() {
        return this.preloadedData;
    }

    @Override
    public final boolean hasForceIndexUsage() {
        return this.forceIndexUsage;
    }

    @Override
    public boolean hasEnabledBatchLoading() {
        return this.hasEnabledBatchLoading;
    }

    @Override
    public final boolean hasVerifyExternalVertexExistence() {
        return this.verifyExternalVertexExistence;
    }

    @Override
    public final boolean hasVerifyInternalVertexExistence() {
        return this.verifyInternalVertexExistence;
    }

    @Override
    public final boolean hasAcquireLocks() {
        return this.acquireLocks;
    }

    @Override
    public final DefaultSchemaMaker getAutoSchemaMaker() {
        return this.defaultSchemaMaker;
    }

    @Override
    public boolean hasDisabledSchemaConstraints() {
        return this.hasDisabledSchemaConstraints;
    }

    @Override
    public final boolean hasVerifyUniqueness() {
        return this.verifyUniqueness;
    }

    @Override
    public boolean hasPropertyPrefetching() {
        return this.propertyPrefetching;
    }

    @Override
    public final boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    @Override
    public final boolean isThreadBound() {
        return this.threadBound;
    }

    @Override
    public final int getVertexCacheSize() {
        return this.vertexCacheSize;
    }

    @Override
    public final int getDirtyVertexSize() {
        return this.dirtyVertexSize;
    }

    @Override
    public final long getIndexCacheWeight() {
        return this.indexCacheWeight;
    }

    @Override
    public String getLogIdentifier() {
        return this.logIdentifier;
    }

    @Override
    public int[] getRestrictedPartitions() {
        return this.restrictedPartitions;
    }

    @Override
    public boolean hasRestrictedPartitions() {
        return this.restrictedPartitions.length > 0;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean hasGroupName() {
        return null != this.groupName;
    }

    @Override
    public Instant getCommitTime() {
        return this.userCommitTime;
    }

    @Override
    public boolean hasCommitTime() {
        return this.userCommitTime != null;
    }

    @Override
    public <V> V getCustomOption(ConfigOption<V> opt) {
        return this.getCustomOptions().get(opt, new String[0]);
    }

    @Override
    public Configuration getCustomOptions() {
        return this.customOptions;
    }

    @Override
    public TimestampProvider getTimestampProvider() {
        return this.graph.getConfiguration().getTimestampProvider();
    }

    private static class ImmutableTxCfg
    implements TransactionConfiguration {
        private final boolean isReadOnly;
        private final boolean hasEnabledBatchLoading;
        private final boolean hasAssignIDsImmediately;
        private final boolean hasPreloadedData;
        private final boolean hasForceIndexUsage;
        private final boolean hasVerifyExternalVertexExistence;
        private final boolean hasVerifyInternalVertexExistence;
        private final boolean hasAcquireLocks;
        private final boolean hasVerifyUniqueness;
        private final boolean hasPropertyPrefetching;
        private final boolean isSingleThreaded;
        private final boolean isThreadBound;
        private final long indexCacheWeight;
        private final int vertexCacheSize;
        private final int dirtyVertexSize;
        private final String logIdentifier;
        private final int[] restrictedPartitions;
        private final DefaultSchemaMaker defaultSchemaMaker;
        private boolean hasDisabledSchemaConstraints = true;
        private final BaseTransactionConfig handleConfig;

        public ImmutableTxCfg(boolean isReadOnly, boolean hasEnabledBatchLoading, boolean hasAssignIDsImmediately, boolean hasPreloadedData, boolean hasForceIndexUsage, boolean hasVerifyExternalVertexExistence, boolean hasVerifyInternalVertexExistence, boolean hasAcquireLocks, boolean hasVerifyUniqueness, boolean hasPropertyPrefetching, boolean isSingleThreaded, boolean isThreadBound, TimestampProvider times, Instant commitTime, long indexCacheWeight, int vertexCacheSize, int dirtyVertexSize, String logIdentifier, int[] restrictedPartitions, String groupName, DefaultSchemaMaker defaultSchemaMaker, boolean hasDisabledSchemaConstraints, Configuration customOptions) {
            this.isReadOnly = isReadOnly;
            this.hasEnabledBatchLoading = hasEnabledBatchLoading;
            this.hasAssignIDsImmediately = hasAssignIDsImmediately;
            this.hasPreloadedData = hasPreloadedData;
            this.hasForceIndexUsage = hasForceIndexUsage;
            this.hasVerifyExternalVertexExistence = hasVerifyExternalVertexExistence;
            this.hasVerifyInternalVertexExistence = hasVerifyInternalVertexExistence;
            this.hasAcquireLocks = hasAcquireLocks;
            this.hasVerifyUniqueness = hasVerifyUniqueness;
            this.hasPropertyPrefetching = hasPropertyPrefetching;
            this.isSingleThreaded = isSingleThreaded;
            this.isThreadBound = isThreadBound;
            this.indexCacheWeight = indexCacheWeight;
            this.vertexCacheSize = vertexCacheSize;
            this.dirtyVertexSize = dirtyVertexSize;
            this.logIdentifier = logIdentifier;
            this.restrictedPartitions = restrictedPartitions;
            this.defaultSchemaMaker = defaultSchemaMaker;
            this.hasDisabledSchemaConstraints = hasDisabledSchemaConstraints;
            this.handleConfig = new StandardBaseTransactionConfig.Builder().commitTime(commitTime).timestampProvider(times).groupName(groupName).customOptions(customOptions).build();
        }

        @Override
        public boolean hasEnabledBatchLoading() {
            return this.hasEnabledBatchLoading;
        }

        @Override
        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        @Override
        public boolean hasAssignIDsImmediately() {
            return this.hasAssignIDsImmediately;
        }

        @Override
        public boolean hasPreloadedData() {
            return this.hasPreloadedData;
        }

        @Override
        public final boolean hasForceIndexUsage() {
            return this.hasForceIndexUsage;
        }

        @Override
        public boolean hasVerifyExternalVertexExistence() {
            return this.hasVerifyExternalVertexExistence;
        }

        @Override
        public boolean hasVerifyInternalVertexExistence() {
            return this.hasVerifyInternalVertexExistence;
        }

        @Override
        public boolean hasAcquireLocks() {
            return this.hasAcquireLocks;
        }

        @Override
        public DefaultSchemaMaker getAutoSchemaMaker() {
            return this.defaultSchemaMaker;
        }

        @Override
        public boolean hasDisabledSchemaConstraints() {
            return this.hasDisabledSchemaConstraints;
        }

        @Override
        public boolean hasVerifyUniqueness() {
            return this.hasVerifyUniqueness;
        }

        @Override
        public boolean hasPropertyPrefetching() {
            return this.hasPropertyPrefetching;
        }

        @Override
        public boolean isSingleThreaded() {
            return this.isSingleThreaded;
        }

        @Override
        public boolean isThreadBound() {
            return this.isThreadBound;
        }

        @Override
        public int getVertexCacheSize() {
            return this.vertexCacheSize;
        }

        @Override
        public int getDirtyVertexSize() {
            return this.dirtyVertexSize;
        }

        @Override
        public long getIndexCacheWeight() {
            return this.indexCacheWeight;
        }

        @Override
        public String getLogIdentifier() {
            return this.logIdentifier;
        }

        @Override
        public int[] getRestrictedPartitions() {
            return this.restrictedPartitions;
        }

        @Override
        public boolean hasRestrictedPartitions() {
            return this.restrictedPartitions.length > 0;
        }

        @Override
        public Instant getCommitTime() {
            return this.handleConfig.getCommitTime();
        }

        @Override
        public void setCommitTime(Instant time) {
            this.handleConfig.setCommitTime(time);
        }

        @Override
        public boolean hasCommitTime() {
            return this.handleConfig.hasCommitTime();
        }

        @Override
        public String getGroupName() {
            return this.handleConfig.getGroupName();
        }

        @Override
        public boolean hasGroupName() {
            return this.handleConfig.hasGroupName();
        }

        @Override
        public <V> V getCustomOption(ConfigOption<V> opt) {
            return this.handleConfig.getCustomOption(opt);
        }

        @Override
        public Configuration getCustomOptions() {
            return this.handleConfig.getCustomOptions();
        }

        @Override
        public TimestampProvider getTimestampProvider() {
            return this.handleConfig.getTimestampProvider();
        }
    }
}

