/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.indexcache;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.transaction.indexcache.IndexCache;

public class ConcurrentIndexCache
implements IndexCache {
    private final HashMultimap<Object, JanusGraphVertexProperty> map = HashMultimap.create();

    @Override
    public synchronized void add(JanusGraphVertexProperty property) {
        this.map.put(property.value(), (Object)property);
    }

    @Override
    public synchronized void remove(JanusGraphVertexProperty property) {
        this.map.remove(property.value(), property);
    }

    @Override
    public synchronized Iterable<JanusGraphVertexProperty> get(Object value, PropertyKey key) {
        ArrayList<JanusGraphVertexProperty> result = new ArrayList<JanusGraphVertexProperty>(4);
        for (JanusGraphVertexProperty p : this.map.get(value)) {
            if (!p.propertyKey().equals(key)) continue;
            result.add(p);
        }
        return result;
    }
}

