/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.lock;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class LockTuple {
    private final Object[] elements;

    public LockTuple(Object ... elements) {
        Preconditions.checkArgument(elements != null && elements.length > 0);
        for (Object o : elements) {
            Preconditions.checkNotNull(o);
        }
        this.elements = elements;
    }

    public int size() {
        return this.elements.length;
    }

    public Object get(int pos) {
        return this.elements[pos];
    }

    public Object[] getAll() {
        return this.elements;
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        for (Object o : this.elements) {
            b.append(o);
        }
        return b.toHashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !(oth instanceof LockTuple)) {
            return false;
        }
        LockTuple other = (LockTuple)oth;
        if (this.elements.length != other.elements.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].equals(other.elements[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(this.elements[i].toString());
        }
        b.append("]");
        return b.toString();
    }
}

