/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.vertexcache;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.transaction.vertexcache.VertexCache;
import org.janusgraph.graphdb.vertices.AbstractVertex;
import org.janusgraph.util.datastructures.Retriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaVertexCache
implements VertexCache {
    private static final Logger log = LoggerFactory.getLogger(GuavaVertexCache.class);
    private final ConcurrentMap<Long, InternalVertex> volatileVertices;
    private final Cache<Long, InternalVertex> cache;

    public GuavaVertexCache(long maxCacheSize, int concurrencyLevel, int initialDirtySize) {
        this.volatileVertices = new NonBlockingHashMapLong<InternalVertex>(initialDirtySize);
        log.debug("Created dirty vertex map with initial size {}", (Object)initialDirtySize);
        this.cache = CacheBuilder.newBuilder().maximumSize(maxCacheSize).concurrencyLevel(concurrencyLevel).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPLICIT) {
                assert (this.volatileVertices.isEmpty());
                return;
            }
            assert (notification.getCause() == RemovalCause.SIZE || notification.getCause() == RemovalCause.REPLACED) : "Cause: " + (Object)((Object)notification.getCause());
            InternalVertex v = (InternalVertex)notification.getValue();
            if (((AbstractVertex)v).isTxOpen() && v.isModified()) {
                this.volatileVertices.putIfAbsent((Long)notification.getKey(), v);
            }
        }).build();
        log.debug("Created vertex cache with max size {}", (Object)maxCacheSize);
    }

    @Override
    public boolean contains(long id) {
        Long vertexId = id;
        return this.cache.getIfPresent(vertexId) != null || this.volatileVertices.containsKey(vertexId);
    }

    @Override
    public InternalVertex get(long id, Retriever<Long, InternalVertex> retriever) {
        Long vertexId = id;
        InternalVertex vertex = this.cache.getIfPresent(vertexId);
        if (vertex == null) {
            InternalVertex newVertex = (InternalVertex)this.volatileVertices.get(vertexId);
            if (newVertex == null) {
                newVertex = retriever.get(vertexId);
            }
            assert (newVertex != null);
            try {
                vertex = this.cache.get(vertexId, new NewVertexCallable(newVertex));
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Should not happen: " + e.getMessage()));
            }
            assert (vertex != null);
        }
        return vertex;
    }

    @Override
    public void add(InternalVertex vertex, long id) {
        Preconditions.checkNotNull(vertex);
        Preconditions.checkArgument(id != 0L);
        Long vertexId = id;
        this.cache.put(vertexId, vertex);
        if (vertex.isNew() || vertex.hasAddedRelations()) {
            this.volatileVertices.put(vertexId, vertex);
        }
    }

    @Override
    public List<InternalVertex> getAllNew() {
        ArrayList<InternalVertex> vertices = new ArrayList<InternalVertex>(10);
        for (InternalVertex v : this.volatileVertices.values()) {
            if (!v.isNew()) continue;
            vertices.add(v);
        }
        return vertices;
    }

    @Override
    public synchronized void close() {
        this.volatileVertices.clear();
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static class NewVertexCallable
    implements Callable<InternalVertex> {
        private final InternalVertex vertex;

        private NewVertexCallable(InternalVertex vertex) {
            this.vertex = vertex;
        }

        @Override
        public InternalVertex call() {
            return this.vertex;
        }
    }
}

