/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;

public interface SchemaSource {
    public long longId();

    public String name();

    public SchemaStatus getStatus();

    public TypeDefinitionMap getDefinition();

    public Iterable<Entry> getRelated(TypeDefinitionCategory var1, Direction var2);

    public void resetCache();

    public IndexType asIndexType();

    public static class Entry {
        private final SchemaSource schemaType;
        private final Object modifier;

        public Entry(SchemaSource schemaType, Object modifier) {
            this.schemaType = Preconditions.checkNotNull(schemaType);
            this.modifier = modifier;
        }

        public SchemaSource getSchemaType() {
            return this.schemaType;
        }

        public Object getModifier() {
            return this.modifier;
        }
    }
}

