/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.StandardRelationTypeMaker;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;

public class StandardPropertyKeyMaker
extends StandardRelationTypeMaker
implements PropertyKeyMaker {
    private Class<?> dataType = null;

    public StandardPropertyKeyMaker(StandardJanusGraphTx tx, String name, IndexSerializer indexSerializer, AttributeHandler attributeHandler) {
        super(tx, name, indexSerializer, attributeHandler);
        this.cardinality(Cardinality.SINGLE);
    }

    @Override
    JanusGraphSchemaCategory getSchemaCategory() {
        return JanusGraphSchemaCategory.PROPERTYKEY;
    }

    @Override
    public StandardPropertyKeyMaker dataType(Class<?> clazz) {
        Preconditions.checkArgument(clazz != null, "Need to specify a data type");
        this.dataType = clazz;
        return this;
    }

    @Override
    public StandardPropertyKeyMaker cardinality(Cardinality cardinality) {
        super.multiplicity(Multiplicity.convert(cardinality));
        return this;
    }

    @Override
    public StandardPropertyKeyMaker invisible() {
        super.invisible();
        return this;
    }

    @Override
    public StandardPropertyKeyMaker signature(PropertyKey ... types) {
        super.signature(types);
        return this;
    }

    @Override
    public StandardPropertyKeyMaker sortKey(PropertyKey ... types) {
        super.sortKey(types);
        return this;
    }

    @Override
    public StandardPropertyKeyMaker sortOrder(Order order) {
        super.sortOrder(order);
        return this;
    }

    @Override
    public PropertyKey make() {
        Preconditions.checkArgument(this.dataType != null, "Need to specify a datatype");
        Preconditions.checkArgument(this.tx.validDataType(this.dataType), "Not a supported data type: %s", new Object[]{this.dataType});
        Preconditions.checkArgument(!this.dataType.isPrimitive(), "Primitive types are not supported. Use the corresponding object type, e.g. Integer.class instead of int.class [%s]", new Object[]{this.dataType});
        Preconditions.checkArgument(!this.dataType.isInterface(), "Datatype must be a class and not an interface: %s", new Object[]{this.dataType});
        Preconditions.checkArgument(this.dataType.isArray() || !Modifier.isAbstract(this.dataType.getModifiers()), "Datatype cannot be an abstract class: %s", new Object[]{this.dataType});
        TypeDefinitionMap definition = this.makeDefinition();
        definition.setValue(TypeDefinitionCategory.DATATYPE, this.dataType);
        return this.tx.makePropertyKey(this.getName(), definition);
    }
}

