/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.RelationTypeMaker;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.system.SystemTypeManager;

public abstract class StandardRelationTypeMaker
implements RelationTypeMaker {
    protected final StandardJanusGraphTx tx;
    protected final IndexSerializer indexSerializer;
    protected final AttributeHandler attributeHandler;
    private String name;
    private boolean isInvisible;
    private final List<PropertyKey> sortKey;
    private Order sortOrder;
    private final List<PropertyKey> signature;
    private Multiplicity multiplicity;
    private SchemaStatus status = SchemaStatus.ENABLED;

    public StandardRelationTypeMaker(StandardJanusGraphTx tx, String name, IndexSerializer indexSerializer, AttributeHandler attributeHandler) {
        this.tx = Preconditions.checkNotNull(tx);
        this.indexSerializer = Preconditions.checkNotNull(indexSerializer);
        this.attributeHandler = Preconditions.checkNotNull(attributeHandler);
        this.name(name);
        this.isInvisible = false;
        this.sortKey = new ArrayList<PropertyKey>(4);
        this.sortOrder = Order.ASC;
        this.signature = new ArrayList<PropertyKey>(4);
        this.multiplicity = Multiplicity.MULTI;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean hasSortKey() {
        return !this.sortKey.isEmpty();
    }

    protected Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    abstract JanusGraphSchemaCategory getSchemaCategory();

    private void checkGeneralArguments() {
        this.checkSortKey(this.sortKey);
        Preconditions.checkArgument(this.sortOrder == Order.ASC || this.hasSortKey(), "Must define a sort key to use ordering");
        StandardRelationTypeMaker.checkSignature(this.signature);
        Preconditions.checkArgument(Sets.intersection(Sets.newHashSet(this.sortKey), Sets.newHashSet(this.signature)).isEmpty(), "Signature and sort key must be disjoined");
        Preconditions.checkArgument(!this.hasSortKey() || !this.multiplicity.isConstrained(), "Cannot define a sort-key on constrained edge labels");
    }

    private long[] checkSortKey(List<PropertyKey> sig) {
        for (PropertyKey key : sig) {
            Preconditions.checkArgument(this.attributeHandler.isOrderPreservingDatatype(key.dataType()), "Key must have an order-preserving data type to be used as sort key: " + key);
        }
        return StandardRelationTypeMaker.checkSignature(sig);
    }

    private static long[] checkSignature(List<PropertyKey> sig) {
        Preconditions.checkArgument(sig.size() == Sets.newHashSet(sig).size(), "Signature and sort key cannot contain duplicate types");
        long[] signature = new long[sig.size()];
        for (int i = 0; i < sig.size(); ++i) {
            PropertyKey key = sig.get(i);
            Preconditions.checkNotNull(key);
            Preconditions.checkArgument(!key.dataType().equals(Object.class), "Signature and sort keys must have a proper declared datatype: %s", new Object[]{key.name()});
            signature[i] = key.longId();
        }
        return signature;
    }

    protected final TypeDefinitionMap makeDefinition() {
        this.checkGeneralArguments();
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INVISIBLE, this.isInvisible);
        def.setValue(TypeDefinitionCategory.SORT_KEY, this.checkSortKey(this.sortKey));
        def.setValue(TypeDefinitionCategory.SORT_ORDER, (Object)this.sortOrder);
        def.setValue(TypeDefinitionCategory.SIGNATURE, StandardRelationTypeMaker.checkSignature(this.signature));
        def.setValue(TypeDefinitionCategory.MULTIPLICITY, (Object)this.multiplicity);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)this.status);
        return def;
    }

    public StandardRelationTypeMaker multiplicity(Multiplicity multiplicity) {
        this.multiplicity = Preconditions.checkNotNull(multiplicity);
        return this;
    }

    @Override
    public StandardRelationTypeMaker signature(PropertyKey ... types) {
        Preconditions.checkArgument(types != null && types.length > 0);
        this.signature.addAll(Arrays.asList(types));
        return this;
    }

    public StandardRelationTypeMaker status(SchemaStatus status) {
        this.status = Preconditions.checkNotNull(status);
        return this;
    }

    public StandardRelationTypeMaker sortKey(PropertyKey ... keys) {
        Preconditions.checkArgument(keys != null && keys.length > 0);
        this.sortKey.addAll(Arrays.asList(keys));
        return this;
    }

    public StandardRelationTypeMaker sortOrder(Order order) {
        this.sortOrder = Preconditions.checkNotNull(order);
        return this;
    }

    public StandardRelationTypeMaker name(String name) {
        SystemTypeManager.throwIfSystemName(this.getSchemaCategory(), name);
        this.name = name;
        return this;
    }

    public StandardRelationTypeMaker invisible() {
        this.isInvisible = true;
        return this;
    }
}

