/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;

public class TypeDefinitionMap
extends EnumMap<TypeDefinitionCategory, Object> {
    public TypeDefinitionMap() {
        super(TypeDefinitionCategory.class);
    }

    public TypeDefinitionMap(TypeDefinitionMap copy) {
        this();
        for (Map.Entry entry : copy.entrySet()) {
            this.setValue((TypeDefinitionCategory)((Object)entry.getKey()), entry.getValue());
        }
    }

    public TypeDefinitionMap setValue(TypeDefinitionCategory type, Object value) {
        assert (type != null);
        assert (value != null);
        assert (type.verifyAttribute(value));
        super.put(type, value);
        return this;
    }

    public <O> O getValue(TypeDefinitionCategory type) {
        assert (type != null);
        Object value = super.get((Object)type);
        return (O)(value == null ? type.defaultValue(this) : value);
    }

    public <O> O getValue(TypeDefinitionCategory type, Class<O> clazz) {
        assert (type != null);
        Object value = super.get((Object)type);
        return (O)(value == null ? type.defaultValue(this) : value);
    }

    public void isValidDefinition(Set<TypeDefinitionCategory> requiredTypes) {
        Set keys = this.keySet();
        for (TypeDefinitionCategory type : requiredTypes) {
            Preconditions.checkArgument(keys.contains((Object)type), "%s not in %s", new Object[]{type, this});
        }
        Preconditions.checkArgument(keys.size() == requiredTypes.size(), "Found irrelevant definitions in: %s", new Object[]{this});
    }

    public void isValidTypeModifierDefinition(Set<TypeDefinitionCategory> legalTypes) {
        Preconditions.checkArgument(1 == this.size(), "exactly one type modifier is expected");
        for (TypeDefinitionCategory type : this.keySet()) {
            Preconditions.checkArgument(legalTypes.contains((Object)type), "%s not legal here");
        }
    }
}

