/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class SubqueryIterator
implements Iterator<JanusGraphElement>,
AutoCloseable {
    private final JointIndexQuery.Subquery subQuery;
    private final Cache<JointIndexQuery.Subquery, List<Object>> indexCache;
    private Iterator<? extends JanusGraphElement> elementIterator;
    private List<Object> currentIds;
    private QueryProfiler profiler;
    private boolean isTimerRunning;

    public SubqueryIterator(JointIndexQuery.Subquery subQuery, IndexSerializer indexSerializer, BackendTransaction tx, Cache<JointIndexQuery.Subquery, List<Object>> indexCache, int limit, Function<Object, ? extends JanusGraphElement> function, List<Object> otherResults) {
        Stream<Object> stream;
        this.subQuery = subQuery;
        this.indexCache = indexCache;
        List<Object> cacheResponse = indexCache.getIfPresent(subQuery);
        if (cacheResponse != null) {
            stream = cacheResponse.stream();
        } else {
            try {
                this.currentIds = new ArrayList<Object>();
                this.profiler = QueryProfiler.startProfile(subQuery.getProfiler(), subQuery);
                this.isTimerRunning = true;
                stream = indexSerializer.query(subQuery, tx).peek(r -> this.currentIds.add(r));
            }
            catch (Exception e2) {
                throw new JanusGraphException("Could not call index", e2.getCause());
            }
        }
        this.elementIterator = stream.filter(e -> otherResults == null || otherResults.contains(e)).limit(limit).map(function).map(r -> r).iterator();
    }

    @Override
    public boolean hasNext() {
        if (!this.elementIterator.hasNext() && this.currentIds != null) {
            this.indexCache.put(this.subQuery, this.currentIds);
            this.profiler.stopTimer();
            this.isTimerRunning = false;
            this.profiler.setResultSize(this.currentIds.size());
        }
        return this.elementIterator.hasNext();
    }

    @Override
    public JanusGraphElement next() {
        return this.elementIterator.next();
    }

    @Override
    public void close() throws Exception {
        if (this.isTimerRunning) {
            this.profiler.stopTimer();
        }
    }
}

