/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.Iterator;
import org.janusgraph.util.datastructures.ArraysUtil;
import org.janusgraph.util.datastructures.IntSet;

public class IntHashSet
extends IntIntHashMap
implements IntSet {
    private static final long serialVersionUID = -7297353805905443841L;
    private static final int defaultValue = 1;

    public IntHashSet() {
    }

    public IntHashSet(int size) {
        super(size);
    }

    @Override
    public boolean add(int value) {
        return super.put(value, 1) == 0;
    }

    @Override
    public boolean addAll(int[] values) {
        boolean addedAll = true;
        for (int value : values) {
            if (this.add(value)) continue;
            addedAll = false;
        }
        return addedAll;
    }

    @Override
    public boolean contains(int value) {
        return super.containsKey(value);
    }

    @Override
    public int[] getAll() {
        IntIntHashMap.KeysContainer keys = this.keys();
        int[] all = new int[keys.size()];
        Iterator<IntCursor> iterator = keys.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            all[pos++] = iterator.next().value;
        }
        return all;
    }

    @Override
    public int hashCode() {
        return ArraysUtil.sum(this.getAll());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntSet)) {
            return false;
        }
        IntSet oth = (IntSet)other;
        for (int value : this.values) {
            if (oth.contains(value)) continue;
            return false;
        }
        return this.size() == oth.size();
    }
}

