/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.encoding;

import com.google.common.base.Preconditions;

public class LongEncoding {
    private static final String BASE_SYMBOLS = "0123456789abcdefghijklmnopqrstuvwxyz";

    public static long decode(String s) {
        return LongEncoding.decode(s, BASE_SYMBOLS);
    }

    public static String encode(long num) {
        return LongEncoding.encode(num, BASE_SYMBOLS);
    }

    public static long decode(String s, String symbols) {
        int B = symbols.length();
        long num = 0L;
        for (char ch : s.toCharArray()) {
            num *= (long)B;
            int pos = symbols.indexOf(ch);
            if (pos < 0) {
                throw new NumberFormatException("Symbol set does not match string");
            }
            num += (long)pos;
        }
        return num;
    }

    public static String encode(long num, String symbols) {
        Preconditions.checkArgument(num >= 0L, "Expected non-negative number: " + num);
        int B = symbols.length();
        StringBuilder sb = new StringBuilder();
        while (num != 0L) {
            sb.append(symbols.charAt((int)(num % (long)B)));
            num /= (long)B;
        }
        return sb.reverse().toString();
    }
}

