/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.encoding;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;

public class StringEncoding {
    public static final String UTF8_ENCODING = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static boolean isAsciiString(String input) {
        Preconditions.checkNotNull(input);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f' && c > '\u0000') continue;
            return false;
        }
        return true;
    }

    public static int writeAsciiString(byte[] array, int startPos, String attribute) {
        Preconditions.checkArgument(StringEncoding.isAsciiString(attribute));
        if (attribute.length() == 0) {
            array[startPos++] = -128;
        } else {
            for (int i = 0; i < attribute.length(); ++i) {
                char c = attribute.charAt(i);
                assert (c <= '\u007f');
                byte b = (byte)c;
                if (i + 1 == attribute.length()) {
                    b = (byte)(b | 0x80);
                }
                array[startPos++] = b;
            }
        }
        return startPos;
    }

    public static String readAsciiString(byte[] array, int startPos) {
        int c;
        StringBuilder sb = new StringBuilder();
        do {
            if ((c = 0xFF & array[startPos++]) == 128) continue;
            sb.append((char)(c & 0x7F));
        } while ((c & 0x80) <= 0);
        return sb.toString();
    }

    public static int getAsciiByteLength(String attribute) {
        Preconditions.checkArgument(StringEncoding.isAsciiString(attribute));
        return attribute.isEmpty() ? 1 : attribute.length();
    }

    public static String launder(String input) {
        Preconditions.checkNotNull(input);
        StringBuilder sb = new StringBuilder();
        input.chars().forEach(c -> sb.append((char)Integer.valueOf(c).intValue()));
        return sb.toString();
    }
}

