/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.OnePointsBuilder;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.noggit.JSONParser;

public class GeoJSONReader
implements ShapeReader {
    protected static final String BUFFER = "buffer";
    protected static final String BUFFER_UNITS = "buffer_units";
    protected final SpatialContext ctx;
    protected final ShapeFactory shapeFactory;

    public GeoJSONReader(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
        this.shapeFactory = ctx.getShapeFactory();
    }

    @Override
    public String getFormatName() {
        return "GeoJSON";
    }

    @Override
    public final Shape read(Reader reader) throws IOException, ParseException {
        return this.readShape(new JSONParser(reader));
    }

    @Override
    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        String v = value.toString().trim();
        return this.read(new StringReader(v));
    }

    @Override
    public Shape readIfSupported(Object value) throws InvalidShapeException {
        String v = value.toString().trim();
        if (!v.startsWith("{") || !v.endsWith("}")) {
            return null;
        }
        try {
            return this.read(new StringReader(v));
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    protected void readCoordXYZ(JSONParser parser, ShapeFactory.PointsBuilder pointsBuilder) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        int idx = 0;
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 2: 
                case 3: 
                case 4: {
                    double value = parser.getDouble();
                    switch (idx) {
                        case 0: {
                            x = value;
                            break;
                        }
                        case 1: {
                            y = value;
                            break;
                        }
                        case 2: {
                            z = value;
                        }
                    }
                    ++idx;
                    break;
                }
                case 10: {
                    if (idx <= 2) {
                        pointsBuilder.pointXY(this.shapeFactory.normX(x), this.shapeFactory.normY(y));
                    } else {
                        pointsBuilder.pointXYZ(this.shapeFactory.normX(x), this.shapeFactory.normY(y), this.shapeFactory.normZ(z));
                    }
                    return;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
    }

    protected void readCoordListXYZ(JSONParser parser, ShapeFactory.PointsBuilder pointsBuilder) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 9: {
                    this.readCoordXYZ(parser, pointsBuilder);
                    break;
                }
                case 10: {
                    return;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
    }

    protected void readUntilEvent(JSONParser parser, int event) throws IOException {
        int evt = parser.lastEvent();
        while (evt != event && evt != 11) {
            evt = parser.nextEvent();
        }
        return;
    }

    protected Shape readPoint(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        OnePointsBuilder onePointsBuilder = new OnePointsBuilder(this.shapeFactory);
        this.readCoordXYZ(parser, onePointsBuilder);
        Point point = onePointsBuilder.getPoint();
        this.readUntilEvent(parser, 8);
        return point;
    }

    protected Shape readLineString(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        ShapeFactory.LineStringBuilder builder = this.shapeFactory.lineString();
        this.readCoordListXYZ(parser, builder);
        builder.buffer(this.readDistance(BUFFER, BUFFER_UNITS, parser));
        Shape out = builder.build();
        this.readUntilEvent(parser, 8);
        return out;
    }

    protected Circle readCircle(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        OnePointsBuilder onePointsBuilder = new OnePointsBuilder(this.shapeFactory);
        this.readCoordXYZ(parser, onePointsBuilder);
        Point point = onePointsBuilder.getPoint();
        return this.shapeFactory.circle(point, this.readDistance("radius", "radius_units", parser));
    }

    protected double readDistance(String distProperty, String distUnitsProperty, JSONParser parser) throws IOException {
        double dist = 0.0;
        String key = null;
        int event = 8;
        int evt = parser.lastEvent();
        while (evt != event && evt != 11) {
            String units;
            evt = parser.nextEvent();
            if (parser.wasKey()) {
                key = parser.getString();
                continue;
            }
            if (evt == 3 || evt == 2) {
                if (!distProperty.equals(key)) continue;
                dist = parser.getDouble();
                continue;
            }
            if (evt != 1 || !distUnitsProperty.equals(key) || !"km".equals(units = parser.getString())) continue;
            dist = DistanceUtils.dist2Degrees(dist, 6371.0087714);
        }
        return this.shapeFactory.normDist(dist);
    }

    protected Shape readShape(JSONParser parser) throws IOException, ParseException {
        String type = null;
        String key = null;
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 1: {
                    if (parser.wasKey()) {
                        key = parser.getString();
                        break;
                    }
                    if ("type".equals(key)) {
                        type = parser.getString();
                        break;
                    }
                    throw new ParseException("Unexpected String Value for key: " + key, (int)parser.getPosition());
                }
                case 9: {
                    if ("coordinates".equals(key)) {
                        Shape shape = this.readShapeFromCoordinates(type, parser);
                        this.readUntilEvent(parser, 8);
                        return shape;
                    }
                    if ("geometries".equals(key)) {
                        ArrayList<Shape> shapes = new ArrayList<Shape>();
                        int sub = parser.nextEvent();
                        while (sub != 11) {
                            if (sub == 7) {
                                Shape s = this.readShape(parser);
                                if (s != null) {
                                    shapes.add(s);
                                }
                            } else if (sub == 8) break;
                            sub = parser.nextEvent();
                        }
                        if (shapes.isEmpty()) {
                            throw new ParseException("Shape Collection with no geometries!", (int)parser.getPosition());
                        }
                        return this.ctx.makeCollection(shapes);
                    }
                    throw new ParseException("Unknown type: " + type, (int)parser.getPosition());
                }
                case 10: {
                    break;
                }
                case 7: {
                    if (key == null) break;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
        throw new RuntimeException("unable to parse shape");
    }

    protected Shape readShapeFromCoordinates(String type, JSONParser parser) throws IOException, ParseException {
        switch (type) {
            case "Point": {
                return this.readPoint(parser);
            }
            case "LineString": {
                return this.readLineString(parser);
            }
            case "Circle": {
                return this.readCircle(parser);
            }
            case "Polygon": {
                return this.readPolygon(parser, this.shapeFactory.polygon()).buildOrRect();
            }
            case "MultiPoint": {
                return this.readMultiPoint(parser);
            }
            case "MultiLineString": {
                return this.readMultiLineString(parser);
            }
            case "MultiPolygon": {
                return this.readMultiPolygon(parser);
            }
        }
        throw new ParseException("Unable to make shape type: " + type, (int)parser.getPosition());
    }

    protected ShapeFactory.PolygonBuilder readPolygon(JSONParser parser, ShapeFactory.PolygonBuilder polygonBuilder) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        boolean firstRing = true;
        int evt = parser.nextEvent();
        while (true) {
            switch (evt) {
                case 9: {
                    if (firstRing) {
                        this.readCoordListXYZ(parser, polygonBuilder);
                        firstRing = false;
                        break;
                    }
                    ShapeFactory.PolygonBuilder.HoleBuilder holeBuilder = polygonBuilder.hole();
                    this.readCoordListXYZ(parser, holeBuilder);
                    holeBuilder.endHole();
                    break;
                }
                case 10: {
                    return polygonBuilder;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
    }

    protected Shape readMultiPoint(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        ShapeFactory.MultiPointBuilder builder = this.shapeFactory.multiPoint();
        this.readCoordListXYZ(parser, builder);
        return builder.build();
    }

    protected Shape readMultiLineString(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        ShapeFactory.MultiLineStringBuilder builder = this.shapeFactory.multiLineString();
        int evt = parser.nextEvent();
        while (true) {
            switch (evt) {
                case 9: {
                    ShapeFactory.LineStringBuilder lineStringBuilder = builder.lineString();
                    this.readCoordListXYZ(parser, lineStringBuilder);
                    builder.add(lineStringBuilder);
                    break;
                }
                case 10: {
                    return builder.build();
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
    }

    protected Shape readMultiPolygon(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        ShapeFactory.MultiPolygonBuilder builder = this.shapeFactory.multiPolygon();
        int evt = parser.nextEvent();
        while (true) {
            switch (evt) {
                case 9: {
                    ShapeFactory.PolygonBuilder polygonBuilder = this.readPolygon(parser, builder.polygon());
                    builder.add(polygonBuilder);
                    break;
                }
                case 10: {
                    return builder.build();
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
    }
}

