/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.slf4j.Logger;

public class RESTCallLogger {
    private Logger log;
    private String serviceName;

    public RESTCallLogger(Logger log, String serviceName) {
        this.log = log;
        this.serviceName = serviceName;
    }

    public RESTCallToken logRESTCall(String serverName, String userId, String methodName) {
        RESTCallToken token = new RESTCallToken(this.serviceName, serverName, userId, methodName);
        this.log.debug(token.getRESTCallStartText());
        return token;
    }

    public void logRESTCallReturn(RESTCallToken token, String response) {
        if (token != null) {
            this.log.debug(token.getRESTCallReturnText(response));
        } else {
            this.log.debug(this.serviceName + ": returned with response " + response);
        }
    }
}

