/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.auditlog.OMAGCommonAuditCode;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class RESTExceptionHandler {
    public void handleNoRequestBody(String userId, String methodName, String serverName) throws InvalidParameterException {
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NO_REQUEST_BODY;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(userId, methodName, serverName);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "requestBody");
    }

    public void detectAndThrowStandardExceptions(String methodName, FFDCResponseBase restResult) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String exceptionClassName;
        String invalidParameterExceptionClassName = InvalidParameterException.class.getName();
        String propertyServerExceptionClassName = PropertyServerException.class.getName();
        String userNotAuthorizedExceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && (exceptionClassName = restResult.getExceptionClassName()) != null) {
            if (exceptionClassName.equals(invalidParameterExceptionClassName)) {
                this.throwInvalidParameterException(methodName, restResult);
            } else if (exceptionClassName.equals(userNotAuthorizedExceptionClassName)) {
                this.throwUserNotAuthorizedException(methodName, restResult);
            } else if (exceptionClassName.equals(propertyServerExceptionClassName)) {
                this.throwPropertyServerException(methodName, restResult);
            } else {
                this.throwUnexpectedException(methodName, restResult);
            }
        }
    }

    public void detectAndThrowInvalidParameterException(String methodName, FFDCResponseBase restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            this.throwInvalidParameterException(methodName, restResult);
        }
    }

    private void throwInvalidParameterException(String methodName, FFDCResponseBase restResult) throws InvalidParameterException {
        Object nameObject;
        String parameterName = null;
        Map<String, Object> exceptionProperties = restResult.getExceptionProperties();
        if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
            parameterName = (String)nameObject;
        }
        throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), parameterName);
    }

    public void detectAndThrowPropertyServerException(String methodName, FFDCResponseBase restResult) throws PropertyServerException {
        String exceptionClassName = PropertyServerException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            this.throwPropertyServerException(methodName, restResult);
        }
    }

    private void throwPropertyServerException(String methodName, FFDCResponseBase restResult) throws PropertyServerException {
        throw new PropertyServerException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
    }

    public void detectAndThrowUserNotAuthorizedException(String methodName, FFDCResponseBase restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            this.throwUserNotAuthorizedException(methodName, restResult);
        }
    }

    private void throwUserNotAuthorizedException(String methodName, FFDCResponseBase restResult) throws UserNotAuthorizedException {
        Object userIdObject;
        String userId = null;
        Map<String, Object> exceptionProperties = restResult.getExceptionProperties();
        if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
            userId = (String)userIdObject;
        }
        throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
    }

    public void handleUnexpectedException(Throwable error, String methodName, String serverName, String serverURL) throws PropertyServerException {
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.CLIENT_SIDE_REST_API_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, serverName, serverURL, error.getMessage());
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
    }

    private void throwUnexpectedException(String methodName, FFDCResponseBase restResult) throws PropertyServerException {
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.UNEXPECTED_EXCEPTION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(restResult.getExceptionClassName(), methodName, restResult.getExceptionErrorMessage());
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
    }

    public void handleWrongTypeForGUIDException(String guid, String methodName, String actualType, String expectedType) throws InvalidParameterException {
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.INSTANCE_WRONG_TYPE_FOR_GUID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, guid, actualType, expectedType);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), expectedType);
    }

    protected void captureCheckedException(FFDCResponseBase response, OCFCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    protected void captureCheckedException(FFDCResponseBase response, OCFCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }

    public void captureThrowable(FFDCResponseBase response, Throwable error, String methodName) {
        this.captureThrowable(response, error, methodName, null);
    }

    public void captureThrowable(FFDCResponseBase response, Throwable error, String methodName, OMRSAuditLog auditLog) {
        if (error instanceof PropertyServerException) {
            this.capturePropertyServerException(response, (PropertyServerException)error);
        } else if (error instanceof UserNotAuthorizedException) {
            this.captureUserNotAuthorizedException(response, (UserNotAuthorizedException)error);
        } else if (error instanceof InvalidParameterException) {
            this.captureInvalidParameterException(response, (InvalidParameterException)error);
        } else {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.UNEXPECTED_EXCEPTION;
            String message = error.getMessage();
            if (message == null) {
                message = "null";
            }
            response.setRelatedHTTPCode(errorCode.getHTTPErrorCode());
            response.setExceptionClassName(error.getClass().getName());
            response.setExceptionErrorMessage(errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, message));
            response.setExceptionSystemAction(errorCode.getSystemAction());
            response.setExceptionUserAction(errorCode.getUserAction());
            response.setExceptionProperties(null);
            if (auditLog != null) {
                StringWriter stackTrace = new StringWriter();
                error.printStackTrace(new PrintWriter(stackTrace));
                OMAGCommonAuditCode auditCode = OMAGCommonAuditCode.UNEXPECTED_EXCEPTION;
                auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getClass().getName(), methodName, message, stackTrace.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
    }

    public void captureInvalidParameterException(FFDCResponseBase response, InvalidParameterException error) {
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", parameterName);
            this.captureCheckedException(response, error, InvalidParameterException.class.getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, error, InvalidParameterException.class.getName());
        }
    }

    public void capturePropertyServerException(FFDCResponseBase response, PropertyServerException error) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(PropertyServerException.class.getName());
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    public void captureUserNotAuthorizedException(FFDCResponseBase response, UserNotAuthorizedException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("userId", userId);
            response.setExceptionProperties(exceptionProperties);
        }
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(UserNotAuthorizedException.class.getName());
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }
}

