/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyIteratorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetPagingIterator
extends AssetPropertyBase
implements Iterator<AssetPropertyBase> {
    protected int maxCacheSize = 1;
    protected int totalElementCount = 0;
    protected int cachedElementStart = 0;
    protected List<AssetPropertyBase> cachedElementList = new ArrayList<AssetPropertyBase>();
    protected int cachedElementPointer = 0;
    protected AssetPropertyIteratorBase iterator = null;
    private static final Logger log = LoggerFactory.getLogger(AssetPagingIterator.class);

    public AssetPagingIterator(AssetDescriptor parentAsset, AssetPropertyIteratorBase iterator, int totalElementCount, int maxCacheSize) {
        super(parentAsset);
        log.debug("New PagingIterator:");
        log.debug("==> totalElementCount: " + totalElementCount);
        log.debug("==> maxCacheSize: " + maxCacheSize);
        if (totalElementCount > 0) {
            this.totalElementCount = totalElementCount;
        }
        if (maxCacheSize > 0) {
            this.maxCacheSize = maxCacheSize;
        }
        if (iterator == null) {
            OCFErrorCode errorCode = OCFErrorCode.NO_ITERATOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getClass().getSimpleName(), super.getParentAssetName(), super.getParentAssetTypeName());
            throw new OCFRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "next", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.iterator = iterator;
    }

    public AssetPagingIterator(AssetDescriptor parentAsset, AssetPropertyIteratorBase iterator, AssetPagingIterator templateIterator) {
        super(parentAsset, templateIterator);
        if (templateIterator != null) {
            this.cachedElementStart = 0;
            this.cachedElementPointer = 0;
            this.cachedElementList = new ArrayList<AssetPropertyBase>();
            if (templateIterator.totalElementCount > 0) {
                this.totalElementCount = templateIterator.totalElementCount;
            }
            if (templateIterator.maxCacheSize > 0) {
                this.maxCacheSize = templateIterator.maxCacheSize;
            }
            if (iterator == null) {
                OCFErrorCode errorCode = OCFErrorCode.NO_ITERATOR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getClass().getSimpleName(), super.getParentAssetName(), super.getParentAssetTypeName());
                throw new OCFRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "next", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.iterator = iterator;
            if (templateIterator.cachedElementStart <= templateIterator.maxCacheSize) {
                for (AssetPropertyBase templateElement : templateIterator.cachedElementList) {
                    this.cachedElementList.add(iterator.cloneElement(parentAsset, templateElement));
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.cachedElementStart < this.totalElementCount;
    }

    @Override
    public AssetPropertyBase next() {
        if (this.hasNext()) {
            if (this.cachedElementPointer == this.cachedElementList.size()) {
                try {
                    this.cachedElementList = this.iterator.getCachedList(this.cachedElementStart, this.maxCacheSize);
                    this.cachedElementPointer = 0;
                }
                catch (PropertyServerException error) {
                    OCFErrorCode errorCode = OCFErrorCode.PROPERTIES_NOT_AVAILABLE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getErrorMessage(), this.toString());
                    throw new OCFRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "next", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
                }
            }
            AssetPropertyBase retrievedElement = this.iterator.cloneElement(this.getParentAsset(), this.cachedElementList.get(this.cachedElementPointer));
            ++this.cachedElementPointer;
            ++this.cachedElementStart;
            log.debug("Returning next element:");
            log.debug("==> totalElementCount: " + this.totalElementCount);
            log.debug("==> cachedElementPointer: " + this.cachedElementPointer);
            log.debug("==> cachedElementStart:" + this.cachedElementStart);
            log.debug("==> maxCacheSize:" + this.maxCacheSize);
            return retrievedElement;
        }
        OCFErrorCode errorCode = OCFErrorCode.NO_MORE_ELEMENTS;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getClass().getSimpleName(), super.getParentAssetName(), super.getParentAssetTypeName());
        throw new OCFRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "next", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public int getElementCount() {
        return this.totalElementCount;
    }

    @Override
    public void remove() {
        OCFErrorCode errorCode = OCFErrorCode.UNABLE_TO_REMOVE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getParentAssetTypeName(), this.getParentAssetName(), this.iterator.getClass().getName());
        throw new OCFRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "remove", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    @Override
    public String toString() {
        return "AssetPagingIterator{maxCacheSize=" + this.maxCacheSize + ", totalElementCount=" + this.totalElementCount + ", cachedElementStart=" + this.cachedElementStart + ", cachedElementList=" + this.cachedElementList + ", cachedElementPointer=" + this.cachedElementPointer + '}';
    }
}

