/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.berkeleydb;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.odpi.openmetadata.governanceservers.openlineage.responses.ffdc.OpenLineageErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.responses.ffdc.exceptions.OpenLineageException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.berkeleydb.IndexingFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.EdgeLabelsBufferGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.VertexLabelsBufferGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyBufferJanusFactory
extends IndexingFactory {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyBufferJanusFactory.class);

    public static JanusGraph openBufferGraph() {
        JanusGraph janusGraph;
        String methodName = "open";
        String storagePath = "./egeria-lineage-repositories/buffer/berkeley";
        String indexPath = "./egeria-lineage-repositories/buffer/searchindex";
        JanusGraphFactory.Builder config = JanusGraphFactory.build().set("storage.backend", "berkeleyje").set("storage.directory", "./egeria-lineage-repositories/buffer/berkeley").set("index.search.backend", "lucene").set("index.search.directory", "./egeria-lineage-repositories/buffer/searchindex");
        try {
            janusGraph = config.open();
        }
        catch (Exception e) {
            log.error("{} could not open graph stored at {}", (Object)"open", (Object)"./egeria-lineage-repositories/buffer/berkeley");
            OpenLineageErrorCode errorCode = OpenLineageErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("./egeria-lineage-repositories/buffer/berkeley", "open", BerkeleyBufferJanusFactory.class.getName());
            throw new OpenLineageException(400, BerkeleyBufferJanusFactory.class.getName(), "open", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            log.info("Updating graph schema, if necessary");
            BerkeleyBufferJanusFactory.initializeGraph(janusGraph);
        }
        catch (OpenLineageException e) {
            log.error("{} Caught exception during graph initialize operation", (Object)"open");
            throw e;
        }
        return janusGraph;
    }

    private static void initializeGraph(JanusGraph graph) {
        String methodName = "initializeGraph";
        try {
            JanusGraphManagement management = graph.openManagement();
            Set<String> vertexLabels = Stream.of(VertexLabelsBufferGraph.values()).map(Enum::name).collect(Collectors.toSet());
            Set<String> relationshipsLabels = Stream.of(EdgeLabelsBufferGraph.values()).map(Enum::name).collect(Collectors.toSet());
            management = BerkeleyBufferJanusFactory.checkAndAddLabelVertexOrEdge(vertexLabels, management);
            management = BerkeleyBufferJanusFactory.checkAndAddLabelVertexOrEdge(relationshipsLabels, management);
            management.commit();
            BerkeleyBufferJanusFactory.createCompositeIndexForVertexProperty("guid", "veguid", true, graph);
            BerkeleyBufferJanusFactory.createCompositeIndexForVertexProperty("name", "vename", false, graph);
            BerkeleyBufferJanusFactory.createCompositeIndexForEdgeProperty("label", "edlabel", graph);
        }
        catch (Exception e) {
            OpenLineageErrorCode errorCode = OpenLineageErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId();
            throw new OpenLineageException(400, BerkeleyBufferJanusFactory.class.getName(), "initializeGraph", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private static JanusGraphManagement checkAndAddLabelVertexOrEdge(Set<String> labels, JanusGraphManagement management) {
        for (String label : labels) {
            if (management.getVertexLabel(label) != null) continue;
            management.makeVertexLabel(label).make();
        }
        return management;
    }
}

