/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.odpi.openmetadata.accessservices.assetlineage.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.LineageEvent;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.governanceservers.openlineage.buffergraphstore.BufferGraphConnectorBase;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph.GraphVertexMapper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph.MainGraphMapper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.cassandra.BufferGraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferGraphConnector
extends BufferGraphConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(BufferGraphConnector.class);
    private JanusGraph bufferGraph;
    private GraphVertexMapper graphVertexMapper = new GraphVertexMapper();
    private JanusGraph mainGraph;

    @Override
    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        this.initializeGraphDB();
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
    }

    private void initializeGraphDB() {
        String graphDB;
        switch (graphDB = this.connectionProperties.getConfigurationProperties().get("graphDB").toString()) {
            case "berkeleydb": {
                break;
            }
            case "cassandra": {
                BufferGraphFactory bufferGraphFactory = new BufferGraphFactory();
                this.bufferGraph = bufferGraphFactory.openBufferGraph(this.connectionProperties);
                break;
            }
        }
    }

    @Override
    public void setMainGraph(Object mainGraph) {
        this.mainGraph = (JanusGraph)mainGraph;
    }

    @Override
    public void addEntity(LineageEvent lineageEvent) {
        GraphTraversalSource g = this.bufferGraph.traversal();
        HashSet verticesToBeAdded = new HashSet();
        lineageEvent.getAssetContext().entrySet().stream().forEach(entry -> {
            if (((Set)entry.getValue()).size() > 1) {
                verticesToBeAdded.addAll((Collection)entry.getValue());
            } else {
                verticesToBeAdded.add(((Set)entry.getValue()).stream().findFirst().get());
            }
        });
        verticesToBeAdded.stream().forEach(entry -> this.addVerticesAndRelationship(g, (GraphContext)entry));
    }

    @Override
    public void schedulerTask() {
        GraphTraversalSource g = this.bufferGraph.traversal();
        List vertices = g.V(new Object[0]).has("vename", (Object)"Process").toList();
        List guidList = vertices.stream().map(v -> (String)v.property("veguid").value()).collect(Collectors.toList());
        for (String guid : guidList) {
            GraphTraversal<Vertex, Vertex> initial = g.V(new Object[0]).has("veguid", (Object)guid).has("displayName", (Object)"initial_load");
            if (initial.hasNext()) continue;
            List inputPath = g.V(new Object[0]).has("veguid", (Object)guid).out("ProcessPort").out("PortDelegation").has("PortImplementation", "portType", "INPUT_PORT").out("PortSchema").out("AttributeForSchema").out("SchemaAttributeType").in("LineageMapping").in("SchemaAttributeType").toList();
            Vertex process = (Vertex)g.V(new Object[0]).has("veguid", (Object)guid).next();
            for (Vertex vertex : inputPath) {
                String vertexGuid = (String)vertex.value("veguid");
                GraphTraversal<Vertex, Vertex> r = g.V(new Object[0]).has("veguid", (Object)vertexGuid).out("SchemaAttributeType").out("LineageMapping");
                Iterator<Vertex> columnOut = this.findPathForOutputAsset((Vertex)r.next(), g);
                if (columnOut == null || !columnOut.hasNext()) continue;
                String columnOutGuid = columnOut.next().values("veguid").next().toString();
                String columnInGuid = vertex.values("veguid").next().toString();
                if (columnOutGuid.isEmpty() || columnInGuid.isEmpty()) continue;
                MainGraphMapper mainGraphMapper = new MainGraphMapper();
                mainGraphMapper.mapStructure(columnInGuid, process, columnOutGuid, this.mainGraph);
            }
        }
        g.tx().commit();
    }

    private void addVerticesAndRelationship(GraphTraversalSource g, GraphContext nodeToNode) {
        LineageEntity fromEntity = nodeToNode.getFromVertex();
        LineageEntity toEntity = nodeToNode.getToVertex();
        Vertex vertexFrom = this.addVertex(g, fromEntity);
        Vertex vertexTo = this.addVertex(g, toEntity);
        this.addRelationship(nodeToNode.getRelationshipGuid(), nodeToNode.getRelationshipType(), vertexFrom, vertexTo);
    }

    private Vertex addVertex(GraphTraversalSource g, LineageEntity lineageEntity) {
        Vertex vertex;
        String methodName = "addVertex";
        GraphTraversal<Vertex, Vertex> vertexIt = g.V(new Object[0]).has("veguid", (Object)lineageEntity.getGuid());
        if (!vertexIt.hasNext()) {
            vertex = (Vertex)g.addV(lineageEntity.getTypeDefName()).next();
            this.addPropertiesToVertex(g, vertex, lineageEntity);
            g.tx().commit();
        } else {
            vertex = (Vertex)vertexIt.next();
            log.debug("{} found existing vertex {}", (Object)"addVertex", (Object)vertex);
            g.tx().rollback();
        }
        return vertex;
    }

    private void addRelationship(String relationshipGuid, String relationshipType, Vertex fromVertex, Vertex toVertex) {
        GraphTraversalSource g;
        GraphTraversal<Edge, Edge> edgeIt;
        String methodName = "addRelationship";
        if (relationshipType == null) {
            log.error("{} Relationship type name is missing", (Object)methodName);
            this.throwException(JanusConnectorErrorCode.RELATIONSHIP_TYPE_NAME_NOT_KNOWN, relationshipGuid, methodName);
        }
        if ((edgeIt = (g = this.bufferGraph.traversal()).E(new Object[0]).has("edguid", (Object)relationshipGuid)).hasNext()) {
            g.tx().rollback();
            this.throwException(JanusConnectorErrorCode.RELATIONSHIP_ALREADY_EXISTS, relationshipGuid, methodName);
            return;
        }
        fromVertex.addEdge(relationshipType, toVertex, new Object[0]);
        g.tx().commit();
    }

    private void addPropertiesToVertex(GraphTraversalSource g, Vertex vertex, LineageEntity lineageEntity) {
        String methodName = "addPropertiesToVertex";
        try {
            this.graphVertexMapper.mapEntityToVertex(lineageEntity, vertex);
        }
        catch (Exception e) {
            log.error("{} Caught exception from entity mapper {}", (Object)"addPropertiesToVertex", (Object)e.getMessage());
            g.tx().rollback();
            this.throwException(JanusConnectorErrorCode.ENTITY_NOT_CREATED, lineageEntity.getGuid(), "addPropertiesToVertex");
        }
    }

    private Iterator<Vertex> findPathForOutputAsset(Vertex v, GraphTraversalSource g) {
        try {
            GraphTraversal<Vertex, Vertex> end = g.V(v.id()).both("SchemaAttributeType").or(__.has("vename", (Object)"RelationalColumn"), __.has("vename", (Object)"TabularColumn"));
            if (!end.hasNext()) {
                GraphTraversal<Vertex, Vertex> next = g.V(v.id()).out("LineageMapping");
                return this.findPathForOutputAsset((Vertex)next.next(), g);
            }
            return end;
        }
        catch (Exception e) {
            log.debug("Vertex does not exitst");
            return null;
        }
    }

    private void throwException(JanusConnectorErrorCode errorCode, String guid, String methodName) {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, methodName, this.getClass().getName());
        throw new JanusConnectorException(this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

