/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph;

import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGraphMapper {
    private static final Logger log = LoggerFactory.getLogger(MainGraphMapper.class);

    public void mapStructure(String columnInGuid, Vertex process, String columnOutGuid, JanusGraph mainGraph) {
        GraphTraversalSource main = mainGraph.traversal();
        String processGuid = (String)process.value("veguid");
        String processName = (String)process.value("name");
        GraphTraversal<Vertex, Vertex> columnInVertex = main.V(new Object[0]).has("veguid", (Object)columnInGuid);
        GraphTraversal<Vertex, Vertex> columnOutVertex = main.V(new Object[0]).has("veguid", (Object)columnOutGuid);
        GraphTraversal<Vertex, Vertex> processVertex = main.V(new Object[0]).has("id", (Object)processGuid);
        if (columnInVertex.hasNext() && columnOutVertex.hasNext()) {
            Vertex vertex = (Vertex)main.addV("SubProcess").next();
            vertex.property("id", UUID.randomUUID());
            vertex.property("veguid", processGuid);
            vertex.property("vename", processName);
            Vertex columnIn = (Vertex)columnInVertex.next();
            Vertex columnOut = (Vertex)columnOutVertex.next();
            columnIn.addEdge("process", vertex, new Object[0]);
            vertex.addEdge("process", columnOut, new Object[0]);
            if (processVertex.hasNext()) {
                Vertex processTopLevel = (Vertex)processVertex.next();
                vertex.addEdge("process", processTopLevel, new Object[0]);
            } else {
                Vertex mainProcess = (Vertex)main.addV("Process").next();
                mainProcess.property("id", processGuid);
                mainProcess.property("vename", processName);
                vertex.addEdge("process", mainProcess, new Object[0]);
            }
            main.tx().commit();
        } else {
            log.debug("Columns does not exist in maingraph with guidIn {} and out {}", (Object)columnInGuid, (Object)columnOutGuid);
            main.tx().rollback();
        }
    }

    private String extractProperty(Vertex process, String propertyName) {
        return (String)process.value(propertyName);
    }
}

