/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.berkeleydb.IndexingFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.cassandra.BufferGraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.EdgeLabelsBufferGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.VertexLabelsBufferGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryForTesting
extends IndexingFactory {
    private static final Logger log = LoggerFactory.getLogger(BufferGraphFactory.class);

    public JanusGraph openBufferGraph(ConnectionProperties connectionProperties) {
        JanusGraph janusGraph;
        String methodName = "open";
        String graphType = (String)connectionProperties.getConfigurationProperties().get("graphType");
        JanusGraphFactory.Builder config = JanusGraphFactory.build().set("storage.backend", connectionProperties.getConfigurationProperties().get("storageBackend")).set("storage.hostname", connectionProperties.getConfigurationProperties().get("storageHostname")).set("storage.cql.cluster-name", connectionProperties.getConfigurationProperties().get("clusterName")).set("storage.cql.keyspace", connectionProperties.getConfigurationProperties().get("storageCqlKeyspace")).set("index.search.backend", connectionProperties.getConfigurationProperties().get("indexSearchBackend")).set("index.search.hostname", connectionProperties.getConfigurationProperties().get("indexSearchHostname"));
        try {
            janusGraph = config.open();
        }
        catch (Exception e) {
            log.error("{} could not open graph stored", e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "open", BufferGraphFactory.class.getName());
            System.out.println(e.getMessage());
            throw new JanusConnectorException(BufferGraphFactory.class.getName(), "open", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            log.info("Updating graph schema, if necessary");
            this.initializeGraph(janusGraph, graphType);
        }
        catch (JanusConnectorException e) {
            log.error("{} Caught exception during graph initialize operation", (Object)"open");
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "open", BufferGraphFactory.class.getName());
            throw new JanusConnectorException(BufferGraphFactory.class.getName(), "open", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return janusGraph;
    }

    private void initializeGraph(JanusGraph graph, String graphType) {
        String methodName = "initializeGraph";
        try {
            JanusGraphManagement management = graph.openManagement();
            HashSet<String> vertexLabels = new HashSet();
            HashSet<String> relationshipsLabels = new HashSet();
            if (graphType.equals("bufferGraph")) {
                vertexLabels = this.schemaBasedOnGraphType(VertexLabelsBufferGraph.class);
                relationshipsLabels = this.schemaBasedOnGraphType(EdgeLabelsBufferGraph.class);
            }
            if (graphType.equals("mainGraph")) {
                // empty if block
            }
            management = this.checkAndAddLabelVertexOrEdge(vertexLabels, management);
            management = this.checkAndAddLabelVertexOrEdge(relationshipsLabels, management);
            management.commit();
        }
        catch (Exception e) {
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId();
            throw new JanusConnectorException(BufferGraphFactory.class.getName(), "initializeGraph", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private <T extends Enum<T>> Set<String> schemaBasedOnGraphType(Class<T> aEnum) {
        return Stream.of(aEnum.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
    }

    private JanusGraphManagement checkAndAddLabelVertexOrEdge(Set<String> labels, JanusGraphManagement management) {
        for (String label : labels) {
            if (management.getVertexLabel(label) != null) continue;
            management.makeVertexLabel(label).make();
        }
        return management;
    }
}

