/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class OMRSDynamicTypeMetadataCollectionBase
extends OMRSMetadataCollectionBase {
    public OMRSDynamicTypeMetadataCollectionBase(OMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super(parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
    }

    @Override
    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        super.newTypeDefParameterValidation(userId, newTypeDef, "newTypeDef", "addTypeDef");
        TypeDef existingTypeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, newTypeDef.getName());
        if (existingTypeDef != null) {
            this.reportTypeDefAlreadyDefined(newTypeDef.getGUID(), newTypeDef.getName(), "addTypeDef");
        }
    }

    @Override
    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        super.newAttributeTypeDefParameterValidation(userId, newAttributeTypeDef, "newAttributeTypeDef", "addAttributeTypeDef");
        AttributeTypeDef existingAttributeTypeDef = this.repositoryHelper.getAttributeTypeDefByName(this.repositoryName, newAttributeTypeDef.getName());
        if (existingAttributeTypeDef != null) {
            this.reportTypeDefAlreadyDefined(newAttributeTypeDef.getGUID(), newAttributeTypeDef.getName(), "addAttributeTypeDef");
        }
    }

    @Override
    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        super.typeDefParameterValidation(userId, typeDef, "typeDef", "verifyTypeDef");
        TypeDef existingTypeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDef.getName());
        if (existingTypeDef == null) {
            return false;
        }
        if (existingTypeDef.getName().equals(typeDef.getName()) && existingTypeDef.getVersion() == typeDef.getVersion() && existingTypeDef.getVersionName().equals(typeDef.getVersionName()) && existingTypeDef.getCreateTime().equals(typeDef.getCreateTime())) {
            return true;
        }
        super.reportTypeDefConflict(typeDef.getGUID(), typeDef.getName(), "verifyTypeDef");
        return false;
    }

    @Override
    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        super.attributeTypeDefParameterValidation(userId, attributeTypeDef, "attributeTypeDef", "verifyAttributeTypeDef");
        AttributeTypeDef existingAttributeTypeDef = this.repositoryHelper.getAttributeTypeDefByName(this.repositoryName, attributeTypeDef.getName());
        if (existingAttributeTypeDef == null) {
            return false;
        }
        if (attributeTypeDef.equals(existingAttributeTypeDef)) {
            return true;
        }
        super.reportTypeDefConflict(attributeTypeDef.getGUID(), attributeTypeDef.getName(), "verifyAttributeTypeDef");
        return false;
    }

    @Override
    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        String typeDefParameterName = "typeDefPatch";
        super.updateTypeDefParameterValidation(userId, typeDefPatch, "updateTypeDef");
        TypeDef existingTypeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeDefPatch.getTypeName());
        if (existingTypeDef == null) {
            super.reportUnknownTypeGUID(typeDefPatch.getTypeDefGUID(), "typeDefPatch", "updateTypeDef");
        }
        return this.repositoryHelper.applyPatch(this.repositoryName, existingTypeDef, typeDefPatch);
    }

    @Override
    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        super.manageTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteTypeDef");
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, obsoleteTypeDefName);
        if (typeDef == null) {
            super.reportUnknownTypeGUID(obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteTypeDef");
        }
        super.reportTypeDefInUse(obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteTypeDef");
    }

    @Override
    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        super.manageAttributeTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteAttributeTypeDef");
        AttributeTypeDef attributeTypeDef = this.repositoryHelper.getAttributeTypeDefByName(this.repositoryName, obsoleteTypeDefName);
        if (attributeTypeDef == null) {
            super.reportUnknownTypeGUID(obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteAttributeTypeDef");
        }
        super.reportTypeDefInUse(obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteAttributeTypeDef");
    }

    @Override
    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        String originalGUIDParameterName = "originalTypeDefGUID";
        String originalNameParameterName = "originalTypeDefName";
        String newGUIDParameterName = "newTypeDefGUID";
        String newNameParameterName = "newTypeDefName";
        super.manageTypeDefParameterValidation(userId, "originalTypeDefGUID", "originalTypeDefName", originalTypeDefGUID, originalTypeDefName, "reIdentifyTypeDef");
        super.manageTypeDefParameterValidation(userId, "newTypeDefGUID", "newTypeDefName", newTypeDefGUID, newTypeDefName, "reIdentifyTypeDef");
        TypeDef existingTypeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, originalTypeDefName);
        if (existingTypeDef == null) {
            super.reportUnknownTypeGUID(originalTypeDefGUID, "originalTypeDefGUID", "reIdentifyTypeDef");
        } else {
            existingTypeDef.setGUID(newTypeDefGUID);
            existingTypeDef.setName(newTypeDefName);
            existingTypeDef.setVersion(existingTypeDef.getVersion() + 1L);
        }
        return existingTypeDef;
    }

    @Override
    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        String originalGUIDParameterName = "originalAttributeTypeDefGUID";
        String originalNameParameterName = "originalAttributeTypeDefName";
        String newGUIDParameterName = "newAttributeTypeDefGUID";
        String newNameParameterName = "newAttributeTypeDefName";
        super.manageAttributeTypeDefParameterValidation(userId, "originalAttributeTypeDefGUID", "originalAttributeTypeDefName", originalAttributeTypeDefGUID, originalAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        super.manageAttributeTypeDefParameterValidation(userId, "newAttributeTypeDefGUID", "newAttributeTypeDefName", newAttributeTypeDefGUID, newAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        AttributeTypeDef existingAttributeTypeDef = this.repositoryHelper.getAttributeTypeDefByName(this.repositoryName, originalAttributeTypeDefName);
        if (existingAttributeTypeDef == null) {
            super.reportUnknownTypeGUID(originalAttributeTypeDefGUID, "originalAttributeTypeDefGUID", "reIdentifyAttributeTypeDef");
        } else {
            existingAttributeTypeDef.setGUID(newAttributeTypeDefGUID);
            existingAttributeTypeDef.setName(newAttributeTypeDefName);
            existingAttributeTypeDef.setVersion(existingAttributeTypeDef.getVersion() + 1L);
        }
        return existingAttributeTypeDef;
    }
}

