/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.Scanner;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    @Nullable
    public static Logger log = Utils.findLogger(Reflections.class);
    protected final transient Configuration configuration;
    protected Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration.getExecutorService() != null);
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
                scanner.setStore(this.store.getOrCreate(scanner.getClass().getSimpleName()));
            }
            this.scan();
        }
    }

    public Reflections(String prefix, Scanner ... scanners) {
        this(new Object[]{prefix, scanners});
    }

    public Reflections(Object ... params) {
        this(ConfigurationBuilder.build(params));
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store(false);
    }

    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            if (log != null) {
                log.warn("given scan urls are empty. set urls in the configuration");
            }
            return;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("going to scan these urls:\n" + Joiner.on("\n").join(this.configuration.getUrls()));
        }
        long time = System.currentTimeMillis();
        int scannedUrls = 0;
        ExecutorService executorService = this.configuration.getExecutorService();
        ArrayList<Future<?>> futures = Lists.newArrayList();
        for (final URL uRL : this.configuration.getUrls()) {
            try {
                if (executorService != null) {
                    futures.add(executorService.submit(new Runnable(){

                        public void run() {
                            if (log != null && log.isDebugEnabled()) {
                                log.debug("[" + Thread.currentThread().toString() + "] scanning " + uRL);
                            }
                            Reflections.this.scan(uRL);
                        }
                    }));
                } else {
                    this.scan(uRL);
                }
                ++scannedUrls;
            }
            catch (ReflectionsException e) {
                if (log == null || !log.isWarnEnabled()) continue;
                log.warn("could not create Vfs.Dir from url. ignoring the exception and continuing", e);
            }
        }
        if (executorService != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        time = System.currentTimeMillis() - time;
        Integer keys = this.store.getKeysCount();
        Integer n = this.store.getValuesCount();
        if (log != null) {
            log.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", time, scannedUrls, keys, n, executorService != null && executorService instanceof ThreadPoolExecutor ? String.format("[using %d cores]", ((ThreadPoolExecutor)executorService).getMaximumPoolSize()) : ""));
        }
    }

    public void scan(URL url) {
        for (Vfs.File file : Vfs.fromURL(url).getFiles()) {
            String input = file.getRelativePath().replace('/', '.');
            if (!this.configuration.acceptsInput(input)) continue;
            Object classObject = null;
            for (Scanner scanner : this.configuration.getScanners()) {
                try {
                    if (!scanner.acceptsInput(input)) continue;
                    classObject = scanner.scan(file, classObject);
                }
                catch (Exception e) {
                    if (log == null || !log.isDebugEnabled()) continue;
                    log.debug("could not scan file " + file.getRelativePath() + " in url " + url.toExternalForm() + " with scanner " + scanner.getClass().getSimpleName(), (Object)e.getMessage());
                }
            }
        }
    }

    public static Reflections collect() {
        return Reflections.collect("META-INF/reflections", new FilterBuilder().include(".*-reflections.xml"), new Serializer[0]);
    }

    public static Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter, Serializer ... optionalSerializer) {
        XmlSerializer serializer = optionalSerializer != null && optionalSerializer.length == 1 ? optionalSerializer[0] : new XmlSerializer();
        Set<URL> urls = ClasspathHelper.forPackage(packagePrefix, new ClassLoader[0]);
        if (urls.isEmpty()) {
            return null;
        }
        long start = System.currentTimeMillis();
        Reflections reflections = new Reflections();
        Iterable<Vfs.File> files = Vfs.findFiles(urls, packagePrefix, resourceNameFilter);
        for (Vfs.File file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.openInputStream();
                reflections.merge(serializer.read(inputStream));
            }
            catch (IOException e) {
                throw new ReflectionsException("could not merge " + file, e);
            }
            finally {
                Utils.close(inputStream);
            }
        }
        if (log != null) {
            Store store = reflections.getStore();
            log.info(String.format("Reflections took %d ms to collect %d url%s, producing %d keys and %d values [%s]", System.currentTimeMillis() - start, urls.size(), urls.size() > 1 ? "s" : "", store.getKeysCount(), store.getValuesCount(), Joiner.on(", ").join(urls)));
        }
        return reflections;
    }

    public Reflections collect(InputStream inputStream) {
        try {
            this.merge(this.configuration.getSerializer().read(inputStream));
            if (log != null) {
                log.info("Reflections collected metadata from input stream using serializer " + this.configuration.getSerializer().getClass().getName());
            }
        }
        catch (Exception ex) {
            throw new ReflectionsException("could not merge input stream", ex);
        }
        return this;
    }

    public Reflections collect(File file) {
        Reflections reflections;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            reflections = this.collect(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ReflectionsException("could not obtain input stream from file " + file, e);
            }
            catch (Throwable throwable) {
                Utils.close(inputStream);
                throw throwable;
            }
        }
        Utils.close(inputStream);
        return reflections;
    }

    public Reflections merge(Reflections reflections) {
        this.store.merge(reflections.store);
        return this;
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set<String> subTypes = this.store.getSubTypesOf(type.getName());
        return Sets.newHashSet(ReflectionUtils.forNames(subTypes, this.configuration.getClassLoaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName());
        return Sets.newHashSet(ReflectionUtils.forNames(typesAnnotatedWith, this.configuration.getClassLoaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName(), honorInherited);
        return Sets.newHashSet(ReflectionUtils.forNames(typesAnnotatedWith, this.configuration.getClassLoaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, true);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        Set<String> types = this.store.getTypesAnnotatedWithDirectly(annotation.annotationType().getName());
        Set<Class<?>> annotated = ReflectionUtils.getAll(Sets.newHashSet(ReflectionUtils.forNames(types, this.configuration.getClassLoaders())), ReflectionUtils.withAnnotation(annotation));
        Set<String> inherited = this.store.getInheritedSubTypes(ReflectionUtils.names(annotated), annotation.annotationType().getName(), honorInherited);
        return Sets.newHashSet(ReflectionUtils.forNames(inherited, this.configuration.getClassLoaders()));
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> annotatedWith = this.store.getMethodsAnnotatedWith(annotation.getName());
        return Utils.getMethodsFromDescriptors(annotatedWith, this.configuration.getClassLoaders());
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return ReflectionUtils.getAll(this.getMethodsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<Method> getMethodsMatchParams(Class<?> ... types) {
        Set<String> methods = this.getStore().get(MethodParameterScanner.class, ReflectionUtils.names(Lists.newArrayList(types)).toString());
        return Utils.getMethodsFromDescriptors(methods, this.configuration.getClassLoaders());
    }

    public Set<Method> getMethodsReturn(Class returnType) {
        Set<String> methods = this.getStore().get(MethodParameterScanner.class, ReflectionUtils.names(returnType));
        return Utils.getMethodsFromDescriptors(methods, this.configuration.getClassLoaders());
    }

    public Set<Method> getConverters(Class<?> from, Class<?> to) {
        return Utils.intersect(this.getMethodsMatchParams(from), this.getMethodsReturn(to));
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        Set<String> methods = this.getStore().get(MethodParameterScanner.class, annotation.getName());
        return Utils.getMethodsFromDescriptors(methods, this.configuration.getClassLoaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Annotation annotation) {
        return ReflectionUtils.getAll(this.getMethodsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> annotatedWith = this.store.getConstructorsAnnotatedWith(annotation.getName());
        return Utils.getConstructorsFromDescriptors(annotatedWith, this.configuration.getClassLoaders());
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Annotation annotation) {
        return ReflectionUtils.getAll(this.getConstructorsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<Constructor> getConstructorsMatchParams(Class<?> ... types) {
        Set<String> constructors = this.getStore().get(MethodParameterScanner.class, ReflectionUtils.names(Lists.newArrayList(types)).toString());
        return Utils.getConstructorsFromDescriptors(constructors, this.configuration.getClassLoaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        Set<String> constructors = this.getStore().get(MethodParameterScanner.class, annotation.getName());
        return Utils.getConstructorsFromDescriptors(constructors, this.configuration.getClassLoaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Annotation annotation) {
        return ReflectionUtils.getAll(this.getConstructorsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        HashSet<Field> result = Sets.newHashSet();
        Set<String> annotatedWith = this.store.getFieldsAnnotatedWith(annotation.getName());
        for (String annotated : annotatedWith) {
            result.add(Utils.getFieldFromString(annotated, this.configuration.getClassLoaders()));
        }
        return result;
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return ReflectionUtils.getAll(this.getFieldsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        return this.store.getResources(namePredicate);
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    public Store getStore() {
        return this.store;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File save(String filename) {
        return this.save(filename, this.configuration.getSerializer());
    }

    public File save(String filename, Serializer serializer) {
        File file = serializer.save(this, filename);
        if (log != null) {
            log.info("Reflections successfully saved in " + file.getAbsolutePath() + " using " + serializer.getClass().getSimpleName());
        }
        return file;
    }
}

