/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.support;

import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.ByteBufferEncoder;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.DataBufferDecoder;
import org.springframework.core.codec.DataBufferEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.ResourceDecoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.FormHttpMessageReader;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageReader;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.json.AbstractJackson2Decoder;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.Jackson2SmileDecoder;
import org.springframework.http.codec.json.Jackson2SmileEncoder;
import org.springframework.http.codec.protobuf.ProtobufDecoder;
import org.springframework.http.codec.protobuf.ProtobufEncoder;
import org.springframework.http.codec.protobuf.ProtobufHttpMessageWriter;
import org.springframework.http.codec.support.BaseCodecConfigurer;
import org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class BaseDefaultCodecs
implements CodecConfigurer.DefaultCodecs {
    static final boolean jackson2Present;
    private static final boolean jackson2SmilePresent;
    private static final boolean jaxb2Present;
    private static final boolean protobufPresent;
    @Nullable
    private Decoder<?> jackson2JsonDecoder;
    @Nullable
    private Encoder<?> jackson2JsonEncoder;
    @Nullable
    private Decoder<?> protobufDecoder;
    @Nullable
    private Encoder<?> protobufEncoder;
    @Nullable
    private Decoder<?> jaxb2Decoder;
    @Nullable
    private Encoder<?> jaxb2Encoder;
    @Nullable
    private Integer maxInMemorySize;
    private boolean enableLoggingRequestDetails = false;
    private boolean registerDefaults = true;

    BaseDefaultCodecs() {
    }

    @Override
    public void jackson2JsonDecoder(Decoder<?> decoder) {
        this.jackson2JsonDecoder = decoder;
    }

    @Override
    public void jackson2JsonEncoder(Encoder<?> encoder) {
        this.jackson2JsonEncoder = encoder;
    }

    @Override
    public void protobufDecoder(Decoder<?> decoder) {
        this.protobufDecoder = decoder;
    }

    @Override
    public void protobufEncoder(Encoder<?> encoder) {
        this.protobufEncoder = encoder;
    }

    @Override
    public void jaxb2Decoder(Decoder<?> decoder) {
        this.jaxb2Decoder = decoder;
    }

    @Override
    public void jaxb2Encoder(Encoder<?> encoder) {
        this.jaxb2Encoder = encoder;
    }

    @Override
    public void maxInMemorySize(int byteCount) {
        this.maxInMemorySize = byteCount;
    }

    @Nullable
    protected Integer maxInMemorySize() {
        return this.maxInMemorySize;
    }

    @Override
    public void enableLoggingRequestDetails(boolean enable) {
        this.enableLoggingRequestDetails = enable;
    }

    protected boolean isEnableLoggingRequestDetails() {
        return this.enableLoggingRequestDetails;
    }

    void registerDefaults(boolean registerDefaults) {
        this.registerDefaults = registerDefaults;
    }

    final List<HttpMessageReader<?>> getTypedReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        readers.add(new DecoderHttpMessageReader<byte[]>(this.init(new ByteArrayDecoder())));
        readers.add(new DecoderHttpMessageReader<ByteBuffer>(this.init(new ByteBufferDecoder())));
        readers.add(new DecoderHttpMessageReader<DataBuffer>(this.init(new DataBufferDecoder())));
        readers.add(new ResourceHttpMessageReader(this.init(new ResourceDecoder())));
        readers.add(new DecoderHttpMessageReader<String>(this.init(StringDecoder.textPlainOnly())));
        if (protobufPresent) {
            ProtobufDecoder decoder = this.protobufDecoder != null ? this.protobufDecoder : this.init(new ProtobufDecoder());
            readers.add(new DecoderHttpMessageReader<Message>(decoder));
        }
        FormHttpMessageReader formReader = new FormHttpMessageReader();
        if (this.maxInMemorySize != null) {
            formReader.setMaxInMemorySize(this.maxInMemorySize);
        }
        formReader.setEnableLoggingRequestDetails(this.enableLoggingRequestDetails);
        readers.add(formReader);
        this.extendTypedReaders(readers);
        return readers;
    }

    private <T extends Decoder<?>> T init(T decoder) {
        if (this.maxInMemorySize != null) {
            if (decoder instanceof AbstractDataBufferDecoder) {
                ((AbstractDataBufferDecoder)decoder).setMaxInMemorySize(this.maxInMemorySize);
            }
            if (decoder instanceof ProtobufDecoder) {
                ((ProtobufDecoder)decoder).setMaxMessageSize(this.maxInMemorySize);
            }
            if (jackson2Present && decoder instanceof AbstractJackson2Decoder) {
                ((AbstractJackson2Decoder)decoder).setMaxInMemorySize(this.maxInMemorySize);
            }
            if (jaxb2Present && decoder instanceof Jaxb2XmlDecoder) {
                ((Jaxb2XmlDecoder)decoder).setMaxInMemorySize(this.maxInMemorySize);
            }
        }
        return decoder;
    }

    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
    }

    final List<HttpMessageReader<?>> getObjectReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        if (jackson2Present) {
            readers.add(new DecoderHttpMessageReader(this.init(this.getJackson2JsonDecoder())));
        }
        if (jackson2SmilePresent) {
            readers.add(new DecoderHttpMessageReader<Object>(this.init(new Jackson2SmileDecoder())));
        }
        if (jaxb2Present) {
            Jaxb2XmlDecoder decoder = this.jaxb2Decoder != null ? this.jaxb2Decoder : this.init(new Jaxb2XmlDecoder());
            readers.add(new DecoderHttpMessageReader<Object>(decoder));
        }
        this.extendObjectReaders(readers);
        return readers;
    }

    protected void extendObjectReaders(List<HttpMessageReader<?>> objectReaders) {
    }

    final List<HttpMessageReader<?>> getCatchAllReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        result.add(new DecoderHttpMessageReader<String>(this.init(StringDecoder.allMimeTypes())));
        return result;
    }

    final List<HttpMessageWriter<?>> getTypedWriters(boolean forMultipart) {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList writers = new ArrayList();
        writers.add(new EncoderHttpMessageWriter<byte[]>(new ByteArrayEncoder()));
        writers.add(new EncoderHttpMessageWriter<ByteBuffer>(new ByteBufferEncoder()));
        writers.add(new EncoderHttpMessageWriter<DataBuffer>(new DataBufferEncoder()));
        writers.add(new ResourceHttpMessageWriter());
        writers.add(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.textPlainOnly()));
        if (!forMultipart) {
            this.extendTypedWriters(writers);
        }
        if (protobufPresent) {
            ProtobufEncoder encoder = this.protobufEncoder != null ? this.protobufEncoder : new ProtobufEncoder();
            writers.add(new ProtobufHttpMessageWriter(encoder));
        }
        return writers;
    }

    protected void extendTypedWriters(List<HttpMessageWriter<?>> typedWriters) {
    }

    final List<HttpMessageWriter<?>> getObjectWriters(boolean forMultipart) {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList writers = new ArrayList();
        if (jackson2Present) {
            writers.add(new EncoderHttpMessageWriter(this.getJackson2JsonEncoder()));
        }
        if (jackson2SmilePresent) {
            writers.add(new EncoderHttpMessageWriter<Object>(new Jackson2SmileEncoder()));
        }
        if (jaxb2Present) {
            Jaxb2XmlEncoder encoder = this.jaxb2Encoder != null ? this.jaxb2Encoder : new Jaxb2XmlEncoder();
            writers.add(new EncoderHttpMessageWriter<Object>(encoder));
        }
        if (!forMultipart) {
            this.extendObjectWriters(writers);
        }
        return writers;
    }

    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
    }

    List<HttpMessageWriter<?>> getCatchAllWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        result.add(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.allMimeTypes()));
        return result;
    }

    protected Decoder<?> getJackson2JsonDecoder() {
        return this.jackson2JsonDecoder != null ? this.jackson2JsonDecoder : new Jackson2JsonDecoder();
    }

    protected Encoder<?> getJackson2JsonEncoder() {
        return this.jackson2JsonEncoder != null ? this.jackson2JsonEncoder : new Jackson2JsonEncoder();
    }

    static {
        ClassLoader classLoader = BaseCodecConfigurer.class.getClassLoader();
        jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", classLoader) && ClassUtils.isPresent("com.fasterxml.jackson.core.JsonGenerator", classLoader);
        jackson2SmilePresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.smile.SmileFactory", classLoader);
        jaxb2Present = ClassUtils.isPresent("javax.xml.bind.Binder", classLoader);
        protobufPresent = ClassUtils.isPresent("com.google.protobuf.Message", classLoader);
    }
}

