/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.berkeleydb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.odpi.openmetadata.governanceservers.openlineage.responses.ffdc.OpenLineageErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyJanusFactory {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJanusFactory.class);

    public static JanusGraph openMainGraph() throws RepositoryErrorException {
        String storagePath = "./egeria-lineage-repositories/main/berkeley";
        String indexPath = "./egeria-lineage-repositories/main/searchindex";
        return BerkeleyJanusFactory.getJanusGraph("./egeria-lineage-repositories/main/berkeley", "./egeria-lineage-repositories/main/searchindex");
    }

    public static JanusGraph openHistoryGraph() throws RepositoryErrorException {
        String storagePath = "./egeria-lineage-repositories/history/berkeley";
        String indexPath = "./egeria-lineage-repositories/history/searchindex";
        return BerkeleyJanusFactory.getJanusGraph("./egeria-lineage-repositories/history/berkeley", "./egeria-lineage-repositories/history/searchindex");
    }

    public static JanusGraph openMockGraph() throws RepositoryErrorException {
        String storagePath = "./egeria-lineage-repositories/mock/berkeley";
        String indexPath = "./egeria-lineage-repositories/mock/searchindex";
        return BerkeleyJanusFactory.getJanusGraph("./egeria-lineage-repositories/mock/berkeley", "./egeria-lineage-repositories/mock/searchindex");
    }

    private static JanusGraph getJanusGraph(String storagePath, String indexPath) throws RepositoryErrorException {
        JanusGraph janusGraph;
        JanusGraphFactory.Builder config = JanusGraphFactory.build().set("storage.backend", (Object)"berkeleyje").set("storage.directory", (Object)storagePath).set("index.search.backend", (Object)"lucene").set("index.search.directory", (Object)indexPath);
        try {
            janusGraph = config.open();
        }
        catch (Exception e) {
            log.error("{} could not open graph stored at {}", (Object)"open", (Object)storagePath);
            OpenLineageErrorCode errorCode = OpenLineageErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{storagePath, "open", BerkeleyJanusFactory.class.getName()});
            throw new RepositoryErrorException(400, BerkeleyJanusFactory.class.getName(), "open", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            log.info("Updating graph schema, if necessary");
            BerkeleyJanusFactory.initializeGraph(janusGraph);
        }
        catch (RepositoryErrorException e) {
            log.error("{} Caught exception during graph initialize operation", (Object)"open");
            throw e;
        }
        return janusGraph;
    }

    private static void initializeGraph(JanusGraph graph) throws RepositoryErrorException {
        String methodName = "initializeGraph";
        try {
            JanusGraphManagement management = graph.openManagement();
            HashSet<String> vertexLabels = new HashSet<String>(Arrays.asList("GlossaryTerm", "RelationalColumn", "RelationalTableType", "RelationalTable", "RelationalDBSchemaType", "DeployedDatabaseSchema", "Database"));
            HashSet<String> relationshipsLabels = new HashSet<String>(Arrays.asList("SchemaAttributeType", "AttributeForSchema", "GlossaryTerm", "SemanticAssignment", "DeployedDatabaseSchema", "Database"));
            management = BerkeleyJanusFactory.checkAndAddLabelVertexOrEdge(vertexLabels, management);
            management = BerkeleyJanusFactory.checkAndAddLabelVertexOrEdge(relationshipsLabels, management);
            management.commit();
        }
        catch (Exception e) {
            OpenLineageErrorCode errorCode = OpenLineageErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId();
            throw new RepositoryErrorException(400, BerkeleyJanusFactory.class.getName(), "initializeGraph", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private static JanusGraphManagement checkAndAddLabelVertexOrEdge(Set<String> labels, JanusGraphManagement management) {
        for (String label : labels) {
            if (management.getVertexLabel(label) != null) continue;
            management.makeVertexLabel(label).make();
        }
        return management;
    }
}

