/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.berkeleydb;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.GraphConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingFactory {
    private static final Logger log = LoggerFactory.getLogger(IndexingFactory.class);

    protected static void createCompositeIndexForVertexProperty(String propertyName, String propertyKeyName, boolean unique, JanusGraph graph) {
        Class<?> clazz;
        String methodName = "createCompositeIndexForVertexProperty";
        String className = GraphConstants.corePropertyTypes.get(propertyName);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} class not found for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyName);
            log.error("{} NO INDEX CREATED for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyName);
            return;
        }
        String indexName = "vertexIndexComposite" + propertyKeyName;
        log.info("INDEX CREATE {}", (Object)indexName);
        JanusGraphManagement management = graph.openManagement();
        try {
            PropertyKey propertyKey;
            JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
            if (existingIndex != null) {
                log.info("{} index {} already exists", (Object)"createCompositeIndexForVertexProperty", (Object)indexName);
                management.rollback();
                return;
            }
            log.info("{} index create {} for vertex property {}", new Object[]{"createCompositeIndexForVertexProperty", indexName, propertyKeyName});
            boolean oldKey = false;
            PropertyKey existingPropertyKey = management.getPropertyKey(propertyKeyName);
            if (existingPropertyKey != null) {
                log.debug("{} property key already exists for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyKeyName);
                propertyKey = existingPropertyKey;
                oldKey = true;
            } else {
                log.debug("{} make property key for property {}", (Object)"createCompositeIndexForVertexProperty", (Object)propertyKeyName);
                propertyKey = management.makePropertyKey(propertyKeyName).dataType(clazz).make();
            }
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Vertex.class).addKey(propertyKey);
            if (unique) {
                indexBuilder.unique();
            }
            JanusGraphIndex index = indexBuilder.buildCompositeIndex();
            if (unique) {
                management.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
            }
            management.commit();
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = graph.openManagement();
                index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug("{} awaitGraphIndexStatus ENABLED for {}", (Object)"createCompositeIndexForVertexProperty", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        }
        catch (Exception e) {
            log.error("{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}", (Object)"createCompositeIndexForVertexProperty", (Object)e);
            management.rollback();
        }
    }

    protected static void createCompositeIndexForEdgeProperty(String propertyName, String propertyKeyName, JanusGraph graph) {
        Class<?> clazz;
        String methodName = "createCompositeIndexForEdgeProperty";
        String className = GraphConstants.corePropertyTypes.get(propertyName);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} class not found for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyName);
            log.error("{} NO INDEX CREATED for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyName);
            return;
        }
        String indexName = "edgeIndexComposite" + propertyKeyName;
        log.info("INDEX CREATE {}", (Object)indexName);
        JanusGraphManagement management = graph.openManagement();
        try {
            PropertyKey propertyKey;
            JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
            if (existingIndex != null) {
                log.info("{} index {} already exists for property {}", new Object[]{"createCompositeIndexForEdgeProperty", indexName, propertyKeyName});
                management.rollback();
                return;
            }
            log.info("{} INDEX CREATE {} for vertex property {}", new Object[]{"createCompositeIndexForEdgeProperty", indexName, propertyKeyName});
            boolean oldKey = false;
            PropertyKey existingPropertyKey = management.getPropertyKey(propertyKeyName);
            if (existingPropertyKey != null) {
                log.debug("{} property key already exists for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyKeyName);
                propertyKey = existingPropertyKey;
                oldKey = true;
            } else {
                log.debug("{} make property key for property {}", (Object)"createCompositeIndexForEdgeProperty", (Object)propertyKeyName);
                propertyKey = management.makePropertyKey(propertyKeyName).dataType(clazz).make();
            }
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Edge.class).addKey(propertyKey);
            JanusGraphIndex index = indexBuilder.buildCompositeIndex();
            management.commit();
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = graph.openManagement();
                index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug("{} awaitGraphIndexStatus ENABLED for {}", (Object)"createCompositeIndexForEdgeProperty", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        }
        catch (Exception e) {
            log.error("{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}", (Object)"createCompositeIndexForEdgeProperty", (Object)e);
            management.rollback();
        }
    }
}

